package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTopicRulesResponse(
    rules: Option[Iterable[zio.aws.iot.model.TopicRuleListItem]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRulesResponse = {
    import ListTopicRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRulesResponse.ReadOnly =
    zio.aws.iot.model.ListTopicRulesResponse.wrap(buildAwsValue())
}
object ListTopicRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRulesResponse =
      zio.aws.iot.model.ListTopicRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def rules: Option[List[zio.aws.iot.model.TopicRuleListItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.iot.model.TopicRuleListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ) extends zio.aws.iot.model.ListTopicRulesResponse.ReadOnly {
    override val rules
        : Option[List[zio.aws.iot.model.TopicRuleListItem.ReadOnly]] = scala
      .Option(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.TopicRuleListItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ): zio.aws.iot.model.ListTopicRulesResponse.ReadOnly = new Wrapper(impl)
}
