package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListV2LoggingLevelsResponse(
    logTargetConfigurations: Option[
      Iterable[zio.aws.iot.model.LogTargetConfiguration]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse = {
    import ListV2LoggingLevelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse
      .builder()
      .optionallyWith(
        logTargetConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logTargetConfigurations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly =
    zio.aws.iot.model.ListV2LoggingLevelsResponse.wrap(buildAwsValue())
}
object ListV2LoggingLevelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListV2LoggingLevelsResponse =
      zio.aws.iot.model.ListV2LoggingLevelsResponse(
        logTargetConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def logTargetConfigurations
        : Option[List[zio.aws.iot.model.LogTargetConfiguration.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLogTargetConfigurations: ZIO[Any, AwsError, List[
      zio.aws.iot.model.LogTargetConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logTargetConfigurations",
      logTargetConfigurations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse
  ) extends zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly {
    override val logTargetConfigurations
        : Option[List[zio.aws.iot.model.LogTargetConfiguration.ReadOnly]] =
      scala
        .Option(impl.logTargetConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.LogTargetConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse
  ): zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly = new Wrapper(impl)
}
