package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  NextToken,
  Timestamp,
  ListSuppressedAlerts,
  SecurityProfileName,
  MaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListViolationEventsRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    thingName: Option[DeviceDefenderThingName] = None,
    securityProfileName: Option[SecurityProfileName] = None,
    behaviorCriteriaType: Option[zio.aws.iot.model.BehaviorCriteriaType] = None,
    listSuppressedAlerts: Option[ListSuppressedAlerts] = None,
    verificationState: Option[zio.aws.iot.model.VerificationState] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListViolationEventsRequest = {
    import ListViolationEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListViolationEventsRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(behaviorCriteriaType.map(value => value.unwrap))(
        _.behaviorCriteriaType
      )
      .optionallyWith(
        listSuppressedAlerts.map(value =>
          ListSuppressedAlerts.unwrap(value): java.lang.Boolean
        )
      )(_.listSuppressedAlerts)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListViolationEventsRequest.ReadOnly =
    zio.aws.iot.model.ListViolationEventsRequest.wrap(buildAwsValue())
}
object ListViolationEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListViolationEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListViolationEventsRequest =
      zio.aws.iot.model.ListViolationEventsRequest(
        startTime,
        endTime,
        thingName.map(value => value),
        securityProfileName.map(value => value),
        behaviorCriteriaType.map(value => value),
        listSuppressedAlerts.map(value => value),
        verificationState.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def thingName: Option[DeviceDefenderThingName]
    def securityProfileName: Option[SecurityProfileName]
    def behaviorCriteriaType: Option[zio.aws.iot.model.BehaviorCriteriaType]
    def listSuppressedAlerts: Option[ListSuppressedAlerts]
    def verificationState: Option[zio.aws.iot.model.VerificationState]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehaviorCriteriaType
        : ZIO[Any, AwsError, zio.aws.iot.model.BehaviorCriteriaType] =
      AwsError.unwrapOptionField("behaviorCriteriaType", behaviorCriteriaType)
    def getListSuppressedAlerts: ZIO[Any, AwsError, ListSuppressedAlerts] =
      AwsError.unwrapOptionField("listSuppressedAlerts", listSuppressedAlerts)
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.iot.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsRequest
  ) extends zio.aws.iot.model.ListViolationEventsRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
    override val thingName: Option[DeviceDefenderThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.DeviceDefenderThingName(value))
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behaviorCriteriaType
        : Option[zio.aws.iot.model.BehaviorCriteriaType] = scala
      .Option(impl.behaviorCriteriaType())
      .map(value => zio.aws.iot.model.BehaviorCriteriaType.wrap(value))
    override val listSuppressedAlerts: Option[ListSuppressedAlerts] = scala
      .Option(impl.listSuppressedAlerts())
      .map(value => zio.aws.iot.model.primitives.ListSuppressedAlerts(value))
    override val verificationState
        : Option[zio.aws.iot.model.VerificationState] = scala
      .Option(impl.verificationState())
      .map(value => zio.aws.iot.model.VerificationState.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsRequest
  ): zio.aws.iot.model.ListViolationEventsRequest.ReadOnly = new Wrapper(impl)
}
