package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListViolationEventsResponse(
    violationEvents: Option[Iterable[zio.aws.iot.model.ViolationEvent]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListViolationEventsResponse = {
    import ListViolationEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
      .builder()
      .optionallyWith(
        violationEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violationEvents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListViolationEventsResponse.ReadOnly =
    zio.aws.iot.model.ListViolationEventsResponse.wrap(buildAwsValue())
}
object ListViolationEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListViolationEventsResponse =
      zio.aws.iot.model.ListViolationEventsResponse(
        violationEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def violationEvents: Option[List[zio.aws.iot.model.ViolationEvent.ReadOnly]]
    def nextToken: Option[NextToken]
    def getViolationEvents
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ViolationEvent.ReadOnly]] =
      AwsError.unwrapOptionField("violationEvents", violationEvents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ) extends zio.aws.iot.model.ListViolationEventsResponse.ReadOnly {
    override val violationEvents
        : Option[List[zio.aws.iot.model.ViolationEvent.ReadOnly]] = scala
      .Option(impl.violationEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.ViolationEvent.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ): zio.aws.iot.model.ListViolationEventsResponse.ReadOnly = new Wrapper(impl)
}
