package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  ManagedJobTemplateName,
  Environment,
  JobDescription,
  ManagedTemplateVersion
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ManagedJobTemplateSummary(
    templateArn: Option[JobTemplateArn] = None,
    templateName: Option[ManagedJobTemplateName] = None,
    description: Option[JobDescription] = None,
    environments: Option[Iterable[Environment]] = None,
    templateVersion: Option[ManagedTemplateVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary = {
    import ManagedJobTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
      .builder()
      .optionallyWith(
        templateArn.map(value => JobTemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            Environment.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        templateVersion.map(value =>
          ManagedTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.templateVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly =
    zio.aws.iot.model.ManagedJobTemplateSummary.wrap(buildAwsValue())
}
object ManagedJobTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ManagedJobTemplateSummary =
      zio.aws.iot.model.ManagedJobTemplateSummary(
        templateArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        environments.map(value => value),
        templateVersion.map(value => value)
      )
    def templateArn: Option[JobTemplateArn]
    def templateName: Option[ManagedJobTemplateName]
    def description: Option[JobDescription]
    def environments: Option[List[Environment]]
    def templateVersion: Option[ManagedTemplateVersion]
    def getTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironments: ZIO[Any, AwsError, List[Environment]] =
      AwsError.unwrapOptionField("environments", environments)
    def getTemplateVersion: ZIO[Any, AwsError, ManagedTemplateVersion] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ) extends zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly {
    override val templateArn: Option[JobTemplateArn] = scala
      .Option(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val templateName: Option[ManagedJobTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.ManagedJobTemplateName(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val environments: Option[List[Environment]] = scala
      .Option(impl.environments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Environment(item)
        }.toList
      )
    override val templateVersion: Option[ManagedTemplateVersion] = scala
      .Option(impl.templateVersion())
      .map(value => zio.aws.iot.model.primitives.ManagedTemplateVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ): zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly = new Wrapper(impl)
}
