package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DimensionName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricDimension(
    dimensionName: DimensionName,
    operator: Option[zio.aws.iot.model.DimensionValueOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MetricDimension = {
    import MetricDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MetricDimension
      .builder()
      .dimensionName(DimensionName.unwrap(dimensionName): java.lang.String)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MetricDimension.ReadOnly =
    zio.aws.iot.model.MetricDimension.wrap(buildAwsValue())
}
object MetricDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MetricDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MetricDimension = zio.aws.iot.model
      .MetricDimension(dimensionName, operator.map(value => value))
    def dimensionName: DimensionName
    def operator: Option[zio.aws.iot.model.DimensionValueOperator]
    def getDimensionName: ZIO[Any, Nothing, DimensionName] =
      ZIO.succeed(dimensionName)
    def getOperator
        : ZIO[Any, AwsError, zio.aws.iot.model.DimensionValueOperator] =
      AwsError.unwrapOptionField("operator", operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MetricDimension
  ) extends zio.aws.iot.model.MetricDimension.ReadOnly {
    override val dimensionName: DimensionName =
      zio.aws.iot.model.primitives.DimensionName(impl.dimensionName())
    override val operator: Option[zio.aws.iot.model.DimensionValueOperator] =
      scala
        .Option(impl.operator())
        .map(value => zio.aws.iot.model.DimensionValueOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MetricDimension
  ): zio.aws.iot.model.MetricDimension.ReadOnly = new Wrapper(impl)
}
