package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  UnsignedLong,
  Cidr,
  Port,
  Number,
  StringValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricValue(
    count: Option[UnsignedLong] = None,
    cidrs: Option[Iterable[Cidr]] = None,
    ports: Option[Iterable[Port]] = None,
    number: Option[Number] = None,
    numbers: Option[Iterable[Number]] = None,
    strings: Option[Iterable[StringValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.MetricValue = {
    import MetricValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MetricValue
      .builder()
      .optionallyWith(
        count.map(value => UnsignedLong.unwrap(value): java.lang.Long)
      )(_.count)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            Cidr.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            Port.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.ports)
      .optionallyWith(
        number.map(value => Number.unwrap(value): java.lang.Double)
      )(_.number)
      .optionallyWith(
        numbers.map(value =>
          value.map { item =>
            Number.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.numbers)
      .optionallyWith(
        strings.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.strings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MetricValue.ReadOnly =
    zio.aws.iot.model.MetricValue.wrap(buildAwsValue())
}
object MetricValue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.MetricValue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MetricValue =
      zio.aws.iot.model.MetricValue(
        count.map(value => value),
        cidrs.map(value => value),
        ports.map(value => value),
        number.map(value => value),
        numbers.map(value => value),
        strings.map(value => value)
      )
    def count: Option[UnsignedLong]
    def cidrs: Option[List[Cidr]]
    def ports: Option[List[Port]]
    def number: Option[Number]
    def numbers: Option[List[Number]]
    def strings: Option[List[StringValue]]
    def getCount: ZIO[Any, AwsError, UnsignedLong] =
      AwsError.unwrapOptionField("count", count)
    def getCidrs: ZIO[Any, AwsError, List[Cidr]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getPorts: ZIO[Any, AwsError, List[Port]] =
      AwsError.unwrapOptionField("ports", ports)
    def getNumber: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("number", number)
    def getNumbers: ZIO[Any, AwsError, List[Number]] =
      AwsError.unwrapOptionField("numbers", numbers)
    def getStrings: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("strings", strings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MetricValue
  ) extends zio.aws.iot.model.MetricValue.ReadOnly {
    override val count: Option[UnsignedLong] = scala
      .Option(impl.count())
      .map(value => zio.aws.iot.model.primitives.UnsignedLong(value))
    override val cidrs: Option[List[Cidr]] = scala
      .Option(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Cidr(item)
        }.toList
      )
    override val ports: Option[List[Port]] = scala
      .Option(impl.ports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Port(item)
        }.toList
      )
    override val number: Option[Number] = scala
      .Option(impl.number())
      .map(value => zio.aws.iot.model.primitives.Number(value))
    override val numbers: Option[List[Number]] = scala
      .Option(impl.numbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Number(item)
        }.toList
      )
    override val strings: Option[List[StringValue]] = scala
      .Option(impl.strings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MetricValue
  ): zio.aws.iot.model.MetricValue.ReadOnly = new Wrapper(impl)
}
