package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleArn,
  MitigationActionId,
  MitigationActionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MitigationAction(
    name: Option[MitigationActionName] = None,
    id: Option[MitigationActionId] = None,
    roleArn: Option[RoleArn] = None,
    actionParams: Option[zio.aws.iot.model.MitigationActionParams] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MitigationAction = {
    import MitigationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MitigationAction
      .builder()
      .optionallyWith(
        name.map(value => MitigationActionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => MitigationActionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(actionParams.map(value => value.buildAwsValue()))(
        _.actionParams
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MitigationAction.ReadOnly =
    zio.aws.iot.model.MitigationAction.wrap(buildAwsValue())
}
object MitigationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MitigationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MitigationAction =
      zio.aws.iot.model.MitigationAction(
        name.map(value => value),
        id.map(value => value),
        roleArn.map(value => value),
        actionParams.map(value => value.asEditable)
      )
    def name: Option[MitigationActionName]
    def id: Option[MitigationActionId]
    def roleArn: Option[RoleArn]
    def actionParams: Option[zio.aws.iot.model.MitigationActionParams.ReadOnly]
    def getName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("id", id)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getActionParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MitigationActionParams.ReadOnly
    ] = AwsError.unwrapOptionField("actionParams", actionParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MitigationAction
  ) extends zio.aws.iot.model.MitigationAction.ReadOnly {
    override val name: Option[MitigationActionName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val id: Option[MitigationActionId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val actionParams
        : Option[zio.aws.iot.model.MitigationActionParams.ReadOnly] = scala
      .Option(impl.actionParams())
      .map(value => zio.aws.iot.model.MitigationActionParams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MitigationAction
  ): zio.aws.iot.model.MitigationAction.ReadOnly = new Wrapper(impl)
}
