package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MitigationActionParams(
    updateDeviceCertificateParams: Option[
      zio.aws.iot.model.UpdateDeviceCertificateParams
    ] = None,
    updateCACertificateParams: Option[
      zio.aws.iot.model.UpdateCACertificateParams
    ] = None,
    addThingsToThingGroupParams: Option[
      zio.aws.iot.model.AddThingsToThingGroupParams
    ] = None,
    replaceDefaultPolicyVersionParams: Option[
      zio.aws.iot.model.ReplaceDefaultPolicyVersionParams
    ] = None,
    enableIoTLoggingParams: Option[zio.aws.iot.model.EnableIoTLoggingParams] =
      None,
    publishFindingToSnsParams: Option[
      zio.aws.iot.model.PublishFindingToSnsParams
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MitigationActionParams = {
    import MitigationActionParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MitigationActionParams
      .builder()
      .optionallyWith(
        updateDeviceCertificateParams.map(value => value.buildAwsValue())
      )(_.updateDeviceCertificateParams)
      .optionallyWith(
        updateCACertificateParams.map(value => value.buildAwsValue())
      )(_.updateCACertificateParams)
      .optionallyWith(
        addThingsToThingGroupParams.map(value => value.buildAwsValue())
      )(_.addThingsToThingGroupParams)
      .optionallyWith(
        replaceDefaultPolicyVersionParams.map(value => value.buildAwsValue())
      )(_.replaceDefaultPolicyVersionParams)
      .optionallyWith(
        enableIoTLoggingParams.map(value => value.buildAwsValue())
      )(_.enableIoTLoggingParams)
      .optionallyWith(
        publishFindingToSnsParams.map(value => value.buildAwsValue())
      )(_.publishFindingToSnsParams)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MitigationActionParams.ReadOnly =
    zio.aws.iot.model.MitigationActionParams.wrap(buildAwsValue())
}
object MitigationActionParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MitigationActionParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MitigationActionParams =
      zio.aws.iot.model.MitigationActionParams(
        updateDeviceCertificateParams.map(value => value.asEditable),
        updateCACertificateParams.map(value => value.asEditable),
        addThingsToThingGroupParams.map(value => value.asEditable),
        replaceDefaultPolicyVersionParams.map(value => value.asEditable),
        enableIoTLoggingParams.map(value => value.asEditable),
        publishFindingToSnsParams.map(value => value.asEditable)
      )
    def updateDeviceCertificateParams
        : Option[zio.aws.iot.model.UpdateDeviceCertificateParams.ReadOnly]
    def updateCACertificateParams
        : Option[zio.aws.iot.model.UpdateCACertificateParams.ReadOnly]
    def addThingsToThingGroupParams
        : Option[zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly]
    def replaceDefaultPolicyVersionParams
        : Option[zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly]
    def enableIoTLoggingParams
        : Option[zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly]
    def publishFindingToSnsParams
        : Option[zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly]
    def getUpdateDeviceCertificateParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.UpdateDeviceCertificateParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateDeviceCertificateParams",
      updateDeviceCertificateParams
    )
    def getUpdateCACertificateParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.UpdateCACertificateParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateCACertificateParams",
      updateCACertificateParams
    )
    def getAddThingsToThingGroupParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "addThingsToThingGroupParams",
      addThingsToThingGroupParams
    )
    def getReplaceDefaultPolicyVersionParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replaceDefaultPolicyVersionParams",
      replaceDefaultPolicyVersionParams
    )
    def getEnableIoTLoggingParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "enableIoTLoggingParams",
      enableIoTLoggingParams
    )
    def getPublishFindingToSnsParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publishFindingToSnsParams",
      publishFindingToSnsParams
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MitigationActionParams
  ) extends zio.aws.iot.model.MitigationActionParams.ReadOnly {
    override val updateDeviceCertificateParams
        : Option[zio.aws.iot.model.UpdateDeviceCertificateParams.ReadOnly] =
      scala
        .Option(impl.updateDeviceCertificateParams())
        .map(value =>
          zio.aws.iot.model.UpdateDeviceCertificateParams.wrap(value)
        )
    override val updateCACertificateParams
        : Option[zio.aws.iot.model.UpdateCACertificateParams.ReadOnly] = scala
      .Option(impl.updateCACertificateParams())
      .map(value => zio.aws.iot.model.UpdateCACertificateParams.wrap(value))
    override val addThingsToThingGroupParams
        : Option[zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly] = scala
      .Option(impl.addThingsToThingGroupParams())
      .map(value => zio.aws.iot.model.AddThingsToThingGroupParams.wrap(value))
    override val replaceDefaultPolicyVersionParams
        : Option[zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly] =
      scala
        .Option(impl.replaceDefaultPolicyVersionParams())
        .map(value =>
          zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.wrap(value)
        )
    override val enableIoTLoggingParams
        : Option[zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly] = scala
      .Option(impl.enableIoTLoggingParams())
      .map(value => zio.aws.iot.model.EnableIoTLoggingParams.wrap(value))
    override val publishFindingToSnsParams
        : Option[zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly] = scala
      .Option(impl.publishFindingToSnsParams())
      .map(value => zio.aws.iot.model.PublishFindingToSnsParams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MitigationActionParams
  ): zio.aws.iot.model.MitigationActionParams.ReadOnly = new Wrapper(impl)
}
