package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  OTAUpdateId,
  OTAUpdateDescription,
  DateType,
  AwsIotJobArn,
  Value,
  AttributeKey,
  OTAUpdateArn,
  AwsIotJobId,
  Target
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OTAUpdateInfo(
    otaUpdateId: Option[OTAUpdateId] = None,
    otaUpdateArn: Option[OTAUpdateArn] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    description: Option[OTAUpdateDescription] = None,
    targets: Option[Iterable[Target]] = None,
    protocols: Option[Iterable[zio.aws.iot.model.Protocol]] = None,
    awsJobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig
    ] = None,
    awsJobPresignedUrlConfig: Option[
      zio.aws.iot.model.AwsJobPresignedUrlConfig
    ] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    otaUpdateFiles: Option[Iterable[zio.aws.iot.model.OTAUpdateFile]] = None,
    otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] = None,
    awsIotJobId: Option[AwsIotJobId] = None,
    awsIotJobArn: Option[AwsIotJobArn] = None,
    errorInfo: Option[zio.aws.iot.model.ErrorInfo] = None,
    additionalParameters: Option[Map[AttributeKey, Value]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.OTAUpdateInfo = {
    import OTAUpdateInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.OTAUpdateInfo
      .builder()
      .optionallyWith(
        otaUpdateId.map(value => OTAUpdateId.unwrap(value): java.lang.String)
      )(_.otaUpdateId)
      .optionallyWith(
        otaUpdateArn.map(value => OTAUpdateArn.unwrap(value): java.lang.String)
      )(_.otaUpdateArn)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        description.map(value =>
          OTAUpdateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            Target.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(
        awsJobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.awsJobExecutionsRolloutConfig)
      .optionallyWith(
        awsJobPresignedUrlConfig.map(value => value.buildAwsValue())
      )(_.awsJobPresignedUrlConfig)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        otaUpdateFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.otaUpdateFiles)
      .optionallyWith(otaUpdateStatus.map(value => value.unwrap))(
        _.otaUpdateStatus
      )
      .optionallyWith(
        awsIotJobId.map(value => AwsIotJobId.unwrap(value): java.lang.String)
      )(_.awsIotJobId)
      .optionallyWith(
        awsIotJobArn.map(value => AwsIotJobArn.unwrap(value): java.lang.String)
      )(_.awsIotJobArn)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        additionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.additionalParameters)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.OTAUpdateInfo.ReadOnly =
    zio.aws.iot.model.OTAUpdateInfo.wrap(buildAwsValue())
}
object OTAUpdateInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.OTAUpdateInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.OTAUpdateInfo =
      zio.aws.iot.model.OTAUpdateInfo(
        otaUpdateId.map(value => value),
        otaUpdateArn.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        description.map(value => value),
        targets.map(value => value),
        protocols.map(value => value),
        awsJobExecutionsRolloutConfig.map(value => value.asEditable),
        awsJobPresignedUrlConfig.map(value => value.asEditable),
        targetSelection.map(value => value),
        otaUpdateFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        otaUpdateStatus.map(value => value),
        awsIotJobId.map(value => value),
        awsIotJobArn.map(value => value),
        errorInfo.map(value => value.asEditable),
        additionalParameters.map(value => value)
      )
    def otaUpdateId: Option[OTAUpdateId]
    def otaUpdateArn: Option[OTAUpdateArn]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def description: Option[OTAUpdateDescription]
    def targets: Option[List[Target]]
    def protocols: Option[List[zio.aws.iot.model.Protocol]]
    def awsJobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly]
    def awsJobPresignedUrlConfig
        : Option[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def otaUpdateFiles: Option[List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]]
    def otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus]
    def awsIotJobId: Option[AwsIotJobId]
    def awsIotJobArn: Option[AwsIotJobArn]
    def errorInfo: Option[zio.aws.iot.model.ErrorInfo.ReadOnly]
    def additionalParameters: Option[Map[AttributeKey, Value]]
    def getOtaUpdateId: ZIO[Any, AwsError, OTAUpdateId] =
      AwsError.unwrapOptionField("otaUpdateId", otaUpdateId)
    def getOtaUpdateArn: ZIO[Any, AwsError, OTAUpdateArn] =
      AwsError.unwrapOptionField("otaUpdateArn", otaUpdateArn)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getDescription: ZIO[Any, AwsError, OTAUpdateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargets: ZIO[Any, AwsError, List[Target]] =
      AwsError.unwrapOptionField("targets", targets)
    def getProtocols: ZIO[Any, AwsError, List[zio.aws.iot.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getAwsJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobExecutionsRolloutConfig",
      awsJobExecutionsRolloutConfig
    )
    def getAwsJobPresignedUrlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobPresignedUrlConfig",
      awsJobPresignedUrlConfig
    )
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getOtaUpdateFiles
        : ZIO[Any, AwsError, List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]] =
      AwsError.unwrapOptionField("otaUpdateFiles", otaUpdateFiles)
    def getOtaUpdateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateStatus] =
      AwsError.unwrapOptionField("otaUpdateStatus", otaUpdateStatus)
    def getAwsIotJobId: ZIO[Any, AwsError, AwsIotJobId] =
      AwsError.unwrapOptionField("awsIotJobId", awsIotJobId)
    def getAwsIotJobArn: ZIO[Any, AwsError, AwsIotJobArn] =
      AwsError.unwrapOptionField("awsIotJobArn", awsIotJobArn)
    def getErrorInfo: ZIO[Any, AwsError, zio.aws.iot.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getAdditionalParameters: ZIO[Any, AwsError, Map[AttributeKey, Value]] =
      AwsError.unwrapOptionField("additionalParameters", additionalParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateInfo
  ) extends zio.aws.iot.model.OTAUpdateInfo.ReadOnly {
    override val otaUpdateId: Option[OTAUpdateId] = scala
      .Option(impl.otaUpdateId())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateId(value))
    override val otaUpdateArn: Option[OTAUpdateArn] = scala
      .Option(impl.otaUpdateArn())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateArn(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val description: Option[OTAUpdateDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateDescription(value))
    override val targets: Option[List[Target]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Target(item)
        }.toList
      )
    override val protocols: Option[List[zio.aws.iot.model.Protocol]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Protocol.wrap(item)
        }.toList
      )
    override val awsJobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly] =
      scala
        .Option(impl.awsJobExecutionsRolloutConfig())
        .map(value =>
          zio.aws.iot.model.AwsJobExecutionsRolloutConfig.wrap(value)
        )
    override val awsJobPresignedUrlConfig
        : Option[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly] = scala
      .Option(impl.awsJobPresignedUrlConfig())
      .map(value => zio.aws.iot.model.AwsJobPresignedUrlConfig.wrap(value))
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val otaUpdateFiles
        : Option[List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]] = scala
      .Option(impl.otaUpdateFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.OTAUpdateFile.wrap(item)
        }.toList
      )
    override val otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] =
      scala
        .Option(impl.otaUpdateStatus())
        .map(value => zio.aws.iot.model.OTAUpdateStatus.wrap(value))
    override val awsIotJobId: Option[AwsIotJobId] = scala
      .Option(impl.awsIotJobId())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobId(value))
    override val awsIotJobArn: Option[AwsIotJobArn] = scala
      .Option(impl.awsIotJobArn())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobArn(value))
    override val errorInfo: Option[zio.aws.iot.model.ErrorInfo.ReadOnly] = scala
      .Option(impl.errorInfo())
      .map(value => zio.aws.iot.model.ErrorInfo.wrap(value))
    override val additionalParameters: Option[Map[AttributeKey, Value]] = scala
      .Option(impl.additionalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .AttributeKey(key) -> zio.aws.iot.model.primitives.Value(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateInfo
  ): zio.aws.iot.model.OTAUpdateInfo.ReadOnly = new Wrapper(impl)
}
