package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyArn, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Policy(
    policyName: Option[PolicyName] = None,
    policyArn: Option[PolicyArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Policy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Policy.ReadOnly =
    zio.aws.iot.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Policy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Policy = zio.aws.iot.model
      .Policy(policyName.map(value => value), policyArn.map(value => value))
    def policyName: Option[PolicyName]
    def policyArn: Option[PolicyArn]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Policy
  ) extends zio.aws.iot.model.Policy.ReadOnly {
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Option[PolicyArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Policy
  ): zio.aws.iot.model.Policy.ReadOnly = new Wrapper(impl)
}
