package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DateType,
  IsDefaultVersion,
  PolicyVersionId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PolicyVersion(
    versionId: Option[PolicyVersionId] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None,
    createDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PolicyVersion = {
    import PolicyVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PolicyVersion
      .builder()
      .optionallyWith(
        versionId.map(value => PolicyVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PolicyVersion.ReadOnly =
    zio.aws.iot.model.PolicyVersion.wrap(buildAwsValue())
}
object PolicyVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.PolicyVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PolicyVersion =
      zio.aws.iot.model.PolicyVersion(
        versionId.map(value => value),
        isDefaultVersion.map(value => value),
        createDate.map(value => value)
      )
    def versionId: Option[PolicyVersionId]
    def isDefaultVersion: Option[IsDefaultVersion]
    def createDate: Option[DateType]
    def getVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersion
  ) extends zio.aws.iot.model.PolicyVersion.ReadOnly {
    override val versionId: Option[PolicyVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersion
  ): zio.aws.iot.model.PolicyVersion.ReadOnly = new Wrapper(impl)
}
