package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ExpiresInSec, RoleArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PresignedUrlConfig(
    roleArn: Option[RoleArn] = None,
    expiresInSec: Option[ExpiresInSec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PresignedUrlConfig = {
    import PresignedUrlConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PresignedUrlConfig
      .builder()
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        expiresInSec.map(value => ExpiresInSec.unwrap(value): java.lang.Long)
      )(_.expiresInSec)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PresignedUrlConfig.ReadOnly =
    zio.aws.iot.model.PresignedUrlConfig.wrap(buildAwsValue())
}
object PresignedUrlConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PresignedUrlConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PresignedUrlConfig =
      zio.aws.iot.model.PresignedUrlConfig(
        roleArn.map(value => value),
        expiresInSec.map(value => value)
      )
    def roleArn: Option[RoleArn]
    def expiresInSec: Option[ExpiresInSec]
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getExpiresInSec: ZIO[Any, AwsError, ExpiresInSec] =
      AwsError.unwrapOptionField("expiresInSec", expiresInSec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PresignedUrlConfig
  ) extends zio.aws.iot.model.PresignedUrlConfig.ReadOnly {
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val expiresInSec: Option[ExpiresInSec] = scala
      .Option(impl.expiresInSec())
      .map(value => zio.aws.iot.model.primitives.ExpiresInSec(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PresignedUrlConfig
  ): zio.aws.iot.model.PresignedUrlConfig.ReadOnly = new Wrapper(impl)
}
