package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AllowAutoRegistration,
  SetAsActive,
  CertificatePem
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterCaCertificateRequest(
    caCertificate: CertificatePem,
    verificationCertificate: CertificatePem,
    setAsActive: Option[SetAsActive] = None,
    allowAutoRegistration: Option[AllowAutoRegistration] = None,
    registrationConfig: Option[zio.aws.iot.model.RegistrationConfig] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest = {
    import RegisterCaCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
      .builder()
      .caCertificate(CertificatePem.unwrap(caCertificate): java.lang.String)
      .verificationCertificate(
        CertificatePem.unwrap(verificationCertificate): java.lang.String
      )
      .optionallyWith(
        setAsActive.map(value => SetAsActive.unwrap(value): java.lang.Boolean)
      )(_.setAsActive)
      .optionallyWith(
        allowAutoRegistration.map(value =>
          AllowAutoRegistration.unwrap(value): java.lang.Boolean
        )
      )(_.allowAutoRegistration)
      .optionallyWith(registrationConfig.map(value => value.buildAwsValue()))(
        _.registrationConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly =
    zio.aws.iot.model.RegisterCaCertificateRequest.wrap(buildAwsValue())
}
object RegisterCaCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCaCertificateRequest =
      zio.aws.iot.model.RegisterCaCertificateRequest(
        caCertificate,
        verificationCertificate,
        setAsActive.map(value => value),
        allowAutoRegistration.map(value => value),
        registrationConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def caCertificate: CertificatePem
    def verificationCertificate: CertificatePem
    def setAsActive: Option[SetAsActive]
    def allowAutoRegistration: Option[AllowAutoRegistration]
    def registrationConfig
        : Option[zio.aws.iot.model.RegistrationConfig.ReadOnly]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getCaCertificate: ZIO[Any, Nothing, CertificatePem] =
      ZIO.succeed(caCertificate)
    def getVerificationCertificate: ZIO[Any, Nothing, CertificatePem] =
      ZIO.succeed(verificationCertificate)
    def getSetAsActive: ZIO[Any, AwsError, SetAsActive] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
    def getAllowAutoRegistration: ZIO[Any, AwsError, AllowAutoRegistration] =
      AwsError.unwrapOptionField("allowAutoRegistration", allowAutoRegistration)
    def getRegistrationConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      AwsError.unwrapOptionField("registrationConfig", registrationConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ) extends zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly {
    override val caCertificate: CertificatePem =
      zio.aws.iot.model.primitives.CertificatePem(impl.caCertificate())
    override val verificationCertificate: CertificatePem =
      zio.aws.iot.model.primitives
        .CertificatePem(impl.verificationCertificate())
    override val setAsActive: Option[SetAsActive] = scala
      .Option(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActive(value))
    override val allowAutoRegistration: Option[AllowAutoRegistration] = scala
      .Option(impl.allowAutoRegistration())
      .map(value => zio.aws.iot.model.primitives.AllowAutoRegistration(value))
    override val registrationConfig
        : Option[zio.aws.iot.model.RegistrationConfig.ReadOnly] = scala
      .Option(impl.registrationConfig())
      .map(value => zio.aws.iot.model.RegistrationConfig.wrap(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ): zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly = new Wrapper(impl)
}
