package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReplaceTopicRuleRequest(
    ruleName: RuleName,
    topicRulePayload: zio.aws.iot.model.TopicRulePayload
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest = {
    import ReplaceTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .topicRulePayload(topicRulePayload.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ReplaceTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.ReplaceTopicRuleRequest.wrap(buildAwsValue())
}
object ReplaceTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ReplaceTopicRuleRequest =
      zio.aws.iot.model
        .ReplaceTopicRuleRequest(ruleName, topicRulePayload.asEditable)
    def ruleName: RuleName
    def topicRulePayload: zio.aws.iot.model.TopicRulePayload.ReadOnly
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
    def getTopicRulePayload
        : ZIO[Any, Nothing, zio.aws.iot.model.TopicRulePayload.ReadOnly] =
      ZIO.succeed(topicRulePayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest
  ) extends zio.aws.iot.model.ReplaceTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
    override val topicRulePayload: zio.aws.iot.model.TopicRulePayload.ReadOnly =
      zio.aws.iot.model.TopicRulePayload.wrap(impl.topicRulePayload())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest
  ): zio.aws.iot.model.ReplaceTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
