package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{Qos, TopicPattern, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RepublishAction(
    roleArn: AwsArn,
    topic: TopicPattern,
    qos: Option[Qos] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RepublishAction = {
    import RepublishAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RepublishAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .topic(TopicPattern.unwrap(topic): java.lang.String)
      .optionallyWith(qos.map(value => Qos.unwrap(value): Integer))(_.qos)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RepublishAction.ReadOnly =
    zio.aws.iot.model.RepublishAction.wrap(buildAwsValue())
}
object RepublishAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RepublishAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RepublishAction =
      zio.aws.iot.model.RepublishAction(roleArn, topic, qos.map(value => value))
    def roleArn: AwsArn
    def topic: TopicPattern
    def qos: Option[Qos]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getTopic: ZIO[Any, Nothing, TopicPattern] = ZIO.succeed(topic)
    def getQos: ZIO[Any, AwsError, Qos] = AwsError.unwrapOptionField("qos", qos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RepublishAction
  ) extends zio.aws.iot.model.RepublishAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val topic: TopicPattern =
      zio.aws.iot.model.primitives.TopicPattern(impl.topic())
    override val qos: Option[Qos] = scala
      .Option(impl.qos())
      .map(value => zio.aws.iot.model.primitives.Qos(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RepublishAction
  ): zio.aws.iot.model.RepublishAction.ReadOnly = new Wrapper(impl)
}
