package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.NumberOfRetries
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RetryCriteria(
    failureType: zio.aws.iot.model.RetryableFailureType,
    numberOfRetries: NumberOfRetries
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RetryCriteria = {
    import RetryCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RetryCriteria
      .builder()
      .failureType(failureType.unwrap)
      .numberOfRetries(NumberOfRetries.unwrap(numberOfRetries): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RetryCriteria.ReadOnly =
    zio.aws.iot.model.RetryCriteria.wrap(buildAwsValue())
}
object RetryCriteria {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.RetryCriteria] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RetryCriteria =
      zio.aws.iot.model.RetryCriteria(failureType, numberOfRetries)
    def failureType: zio.aws.iot.model.RetryableFailureType
    def numberOfRetries: NumberOfRetries
    def getFailureType
        : ZIO[Any, Nothing, zio.aws.iot.model.RetryableFailureType] =
      ZIO.succeed(failureType)
    def getNumberOfRetries: ZIO[Any, Nothing, NumberOfRetries] =
      ZIO.succeed(numberOfRetries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RetryCriteria
  ) extends zio.aws.iot.model.RetryCriteria.ReadOnly {
    override val failureType: zio.aws.iot.model.RetryableFailureType =
      zio.aws.iot.model.RetryableFailureType.wrap(impl.failureType())
    override val numberOfRetries: NumberOfRetries =
      zio.aws.iot.model.primitives.NumberOfRetries(impl.numberOfRetries())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RetryCriteria
  ): zio.aws.iot.model.RetryCriteria.ReadOnly = new Wrapper(impl)
}
