package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleAliasArn,
  RoleAlias,
  RoleArn,
  DateType,
  CredentialDurationSeconds,
  AwsAccountId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RoleAliasDescription(
    roleAlias: Option[RoleAlias] = None,
    roleAliasArn: Option[RoleAliasArn] = None,
    roleArn: Option[RoleArn] = None,
    owner: Option[AwsAccountId] = None,
    credentialDurationSeconds: Option[CredentialDurationSeconds] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RoleAliasDescription = {
    import RoleAliasDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RoleAliasDescription
      .builder()
      .optionallyWith(
        roleAlias.map(value => RoleAlias.unwrap(value): java.lang.String)
      )(_.roleAlias)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        owner.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        credentialDurationSeconds.map(value =>
          CredentialDurationSeconds.unwrap(value): Integer
        )
      )(_.credentialDurationSeconds)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RoleAliasDescription.ReadOnly =
    zio.aws.iot.model.RoleAliasDescription.wrap(buildAwsValue())
}
object RoleAliasDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RoleAliasDescription =
      zio.aws.iot.model.RoleAliasDescription(
        roleAlias.map(value => value),
        roleAliasArn.map(value => value),
        roleArn.map(value => value),
        owner.map(value => value),
        credentialDurationSeconds.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def roleAlias: Option[RoleAlias]
    def roleAliasArn: Option[RoleAliasArn]
    def roleArn: Option[RoleArn]
    def owner: Option[AwsAccountId]
    def credentialDurationSeconds: Option[CredentialDurationSeconds]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def getRoleAlias: ZIO[Any, AwsError, RoleAlias] =
      AwsError.unwrapOptionField("roleAlias", roleAlias)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getOwner: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("owner", owner)
    def getCredentialDurationSeconds
        : ZIO[Any, AwsError, CredentialDurationSeconds] = AwsError
      .unwrapOptionField("credentialDurationSeconds", credentialDurationSeconds)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ) extends zio.aws.iot.model.RoleAliasDescription.ReadOnly {
    override val roleAlias: Option[RoleAlias] = scala
      .Option(impl.roleAlias())
      .map(value => zio.aws.iot.model.primitives.RoleAlias(value))
    override val roleAliasArn: Option[RoleAliasArn] = scala
      .Option(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val owner: Option[AwsAccountId] = scala
      .Option(impl.owner())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val credentialDurationSeconds: Option[CredentialDurationSeconds] =
      scala
        .Option(impl.credentialDurationSeconds())
        .map(value =>
          zio.aws.iot.model.primitives.CredentialDurationSeconds(value)
        )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ): zio.aws.iot.model.RoleAliasDescription.ReadOnly = new Wrapper(impl)
}
