package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchIndexResponse(
    nextToken: Option[NextToken] = None,
    things: Option[Iterable[zio.aws.iot.model.ThingDocument]] = None,
    thingGroups: Option[Iterable[zio.aws.iot.model.ThingGroupDocument]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SearchIndexResponse = {
    import SearchIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SearchIndexResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        thingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thingGroups)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SearchIndexResponse.ReadOnly =
    zio.aws.iot.model.SearchIndexResponse.wrap(buildAwsValue())
}
object SearchIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SearchIndexResponse =
      zio.aws.iot.model.SearchIndexResponse(
        nextToken.map(value => value),
        things.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        thingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def things: Option[List[zio.aws.iot.model.ThingDocument.ReadOnly]]
    def thingGroups: Option[List[zio.aws.iot.model.ThingGroupDocument.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getThings
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ThingDocument.ReadOnly]] =
      AwsError.unwrapOptionField("things", things)
    def getThingGroups: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ThingGroupDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("thingGroups", thingGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ) extends zio.aws.iot.model.SearchIndexResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val things
        : Option[List[zio.aws.iot.model.ThingDocument.ReadOnly]] = scala
      .Option(impl.things())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.ThingDocument.wrap(item)
        }.toList
      )
    override val thingGroups
        : Option[List[zio.aws.iot.model.ThingGroupDocument.ReadOnly]] = scala
      .Option(impl.thingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.ThingGroupDocument.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ): zio.aws.iot.model.SearchIndexResponse.ReadOnly = new Wrapper(impl)
}
