package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyVersionId, PolicyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetDefaultPolicyVersionRequest(
    policyName: PolicyName,
    policyVersionId: PolicyVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest = {
    import SetDefaultPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyVersionId(
        PolicyVersionId.unwrap(policyVersionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SetDefaultPolicyVersionRequest.ReadOnly =
    zio.aws.iot.model.SetDefaultPolicyVersionRequest.wrap(buildAwsValue())
}
object SetDefaultPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SetDefaultPolicyVersionRequest =
      zio.aws.iot.model
        .SetDefaultPolicyVersionRequest(policyName, policyVersionId)
    def policyName: PolicyName
    def policyVersionId: PolicyVersionId
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyVersionId: ZIO[Any, Nothing, PolicyVersionId] =
      ZIO.succeed(policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest
  ) extends zio.aws.iot.model.SetDefaultPolicyVersionRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val policyVersionId: PolicyVersionId =
      zio.aws.iot.model.primitives.PolicyVersionId(impl.policyVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest
  ): zio.aws.iot.model.SetDefaultPolicyVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
