package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SnsAction(
    targetArn: AwsArn,
    roleArn: AwsArn,
    messageFormat: Option[zio.aws.iot.model.MessageFormat] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.SnsAction = {
    import SnsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SnsAction
      .builder()
      .targetArn(AwsArn.unwrap(targetArn): java.lang.String)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SnsAction.ReadOnly =
    zio.aws.iot.model.SnsAction.wrap(buildAwsValue())
}
object SnsAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.SnsAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SnsAction = zio.aws.iot.model
      .SnsAction(targetArn, roleArn, messageFormat.map(value => value))
    def targetArn: AwsArn
    def roleArn: AwsArn
    def messageFormat: Option[zio.aws.iot.model.MessageFormat]
    def getTargetArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(targetArn)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getMessageFormat: ZIO[Any, AwsError, zio.aws.iot.model.MessageFormat] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SnsAction
  ) extends zio.aws.iot.model.SnsAction.ReadOnly {
    override val targetArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.targetArn())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val messageFormat: Option[zio.aws.iot.model.MessageFormat] = scala
      .Option(impl.messageFormat())
      .map(value => zio.aws.iot.model.MessageFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SnsAction
  ): zio.aws.iot.model.SnsAction.ReadOnly = new Wrapper(impl)
}
