package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SigningProfileName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartSigningJobParameter(
    signingProfileParameter: Option[zio.aws.iot.model.SigningProfileParameter] =
      None,
    signingProfileName: Option[SigningProfileName] = None,
    destination: Option[zio.aws.iot.model.Destination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartSigningJobParameter = {
    import StartSigningJobParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartSigningJobParameter
      .builder()
      .optionallyWith(
        signingProfileParameter.map(value => value.buildAwsValue())
      )(_.signingProfileParameter)
      .optionallyWith(
        signingProfileName.map(value =>
          SigningProfileName.unwrap(value): java.lang.String
        )
      )(_.signingProfileName)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StartSigningJobParameter.ReadOnly =
    zio.aws.iot.model.StartSigningJobParameter.wrap(buildAwsValue())
}
object StartSigningJobParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartSigningJobParameter =
      zio.aws.iot.model.StartSigningJobParameter(
        signingProfileParameter.map(value => value.asEditable),
        signingProfileName.map(value => value),
        destination.map(value => value.asEditable)
      )
    def signingProfileParameter
        : Option[zio.aws.iot.model.SigningProfileParameter.ReadOnly]
    def signingProfileName: Option[SigningProfileName]
    def destination: Option[zio.aws.iot.model.Destination.ReadOnly]
    def getSigningProfileParameter: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.SigningProfileParameter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signingProfileParameter",
      signingProfileParameter
    )
    def getSigningProfileName: ZIO[Any, AwsError, SigningProfileName] =
      AwsError.unwrapOptionField("signingProfileName", signingProfileName)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.iot.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ) extends zio.aws.iot.model.StartSigningJobParameter.ReadOnly {
    override val signingProfileParameter
        : Option[zio.aws.iot.model.SigningProfileParameter.ReadOnly] = scala
      .Option(impl.signingProfileParameter())
      .map(value => zio.aws.iot.model.SigningProfileParameter.wrap(value))
    override val signingProfileName: Option[SigningProfileName] = scala
      .Option(impl.signingProfileName())
      .map(value => zio.aws.iot.model.primitives.SigningProfileName(value))
    override val destination: Option[zio.aws.iot.model.Destination.ReadOnly] =
      scala
        .Option(impl.destination())
        .map(value => zio.aws.iot.model.Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ): zio.aws.iot.model.StartSigningJobParameter.ReadOnly = new Wrapper(impl)
}
