package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Variance,
  Minimum,
  Maximum,
  Average,
  Count,
  Sum,
  SumOfSquares,
  StdDeviation
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Statistics(
    count: Option[Count] = None,
    average: Option[Average] = None,
    sum: Option[Sum] = None,
    minimum: Option[Minimum] = None,
    maximum: Option[Maximum] = None,
    sumOfSquares: Option[SumOfSquares] = None,
    variance: Option[Variance] = None,
    stdDeviation: Option[StdDeviation] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Statistics = {
    import Statistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Statistics
      .builder()
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .optionallyWith(
        average.map(value => Average.unwrap(value): java.lang.Double)
      )(_.average)
      .optionallyWith(sum.map(value => Sum.unwrap(value): java.lang.Double))(
        _.sum
      )
      .optionallyWith(
        minimum.map(value => Minimum.unwrap(value): java.lang.Double)
      )(_.minimum)
      .optionallyWith(
        maximum.map(value => Maximum.unwrap(value): java.lang.Double)
      )(_.maximum)
      .optionallyWith(
        sumOfSquares.map(value => SumOfSquares.unwrap(value): java.lang.Double)
      )(_.sumOfSquares)
      .optionallyWith(
        variance.map(value => Variance.unwrap(value): java.lang.Double)
      )(_.variance)
      .optionallyWith(
        stdDeviation.map(value => StdDeviation.unwrap(value): java.lang.Double)
      )(_.stdDeviation)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Statistics.ReadOnly =
    zio.aws.iot.model.Statistics.wrap(buildAwsValue())
}
object Statistics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Statistics] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Statistics = zio.aws.iot.model.Statistics(
      count.map(value => value),
      average.map(value => value),
      sum.map(value => value),
      minimum.map(value => value),
      maximum.map(value => value),
      sumOfSquares.map(value => value),
      variance.map(value => value),
      stdDeviation.map(value => value)
    )
    def count: Option[Count]
    def average: Option[Average]
    def sum: Option[Sum]
    def minimum: Option[Minimum]
    def maximum: Option[Maximum]
    def sumOfSquares: Option[SumOfSquares]
    def variance: Option[Variance]
    def stdDeviation: Option[StdDeviation]
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
    def getAverage: ZIO[Any, AwsError, Average] =
      AwsError.unwrapOptionField("average", average)
    def getSum: ZIO[Any, AwsError, Sum] = AwsError.unwrapOptionField("sum", sum)
    def getMinimum: ZIO[Any, AwsError, Minimum] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, Maximum] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getSumOfSquares: ZIO[Any, AwsError, SumOfSquares] =
      AwsError.unwrapOptionField("sumOfSquares", sumOfSquares)
    def getVariance: ZIO[Any, AwsError, Variance] =
      AwsError.unwrapOptionField("variance", variance)
    def getStdDeviation: ZIO[Any, AwsError, StdDeviation] =
      AwsError.unwrapOptionField("stdDeviation", stdDeviation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Statistics
  ) extends zio.aws.iot.model.Statistics.ReadOnly {
    override val count: Option[Count] = scala
      .Option(impl.count())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val average: Option[Average] = scala
      .Option(impl.average())
      .map(value => zio.aws.iot.model.primitives.Average(value))
    override val sum: Option[Sum] = scala
      .Option(impl.sum())
      .map(value => zio.aws.iot.model.primitives.Sum(value))
    override val minimum: Option[Minimum] = scala
      .Option(impl.minimum())
      .map(value => zio.aws.iot.model.primitives.Minimum(value))
    override val maximum: Option[Maximum] = scala
      .Option(impl.maximum())
      .map(value => zio.aws.iot.model.primitives.Maximum(value))
    override val sumOfSquares: Option[SumOfSquares] = scala
      .Option(impl.sumOfSquares())
      .map(value => zio.aws.iot.model.primitives.SumOfSquares(value))
    override val variance: Option[Variance] = scala
      .Option(impl.variance())
      .map(value => zio.aws.iot.model.primitives.Variance(value))
    override val stdDeviation: Option[StdDeviation] = scala
      .Option(impl.stdDeviation())
      .map(value => zio.aws.iot.model.primitives.StdDeviation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Statistics
  ): zio.aws.iot.model.Statistics.ReadOnly = new Wrapper(impl)
}
