package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{FileId, StreamId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Stream(
    streamId: Option[StreamId] = None,
    fileId: Option[FileId] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Stream = {
    import Stream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Stream
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(fileId.map(value => FileId.unwrap(value): Integer))(
        _.fileId
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Stream.ReadOnly =
    zio.aws.iot.model.Stream.wrap(buildAwsValue())
}
object Stream {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Stream] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Stream = zio.aws.iot.model
      .Stream(streamId.map(value => value), fileId.map(value => value))
    def streamId: Option[StreamId]
    def fileId: Option[FileId]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getFileId: ZIO[Any, AwsError, FileId] =
      AwsError.unwrapOptionField("fileId", fileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Stream
  ) extends zio.aws.iot.model.Stream.ReadOnly {
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val fileId: Option[FileId] = scala
      .Option(impl.fileId())
      .map(value => zio.aws.iot.model.primitives.FileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Stream
  ): zio.aws.iot.model.Stream.ReadOnly = new Wrapper(impl)
}
