package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.FileId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StreamFile(
    fileId: Option[FileId] = None,
    s3Location: Option[zio.aws.iot.model.S3Location] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.StreamFile = {
    import StreamFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StreamFile
      .builder()
      .optionallyWith(fileId.map(value => FileId.unwrap(value): Integer))(
        _.fileId
      )
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StreamFile.ReadOnly =
    zio.aws.iot.model.StreamFile.wrap(buildAwsValue())
}
object StreamFile {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.StreamFile] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StreamFile = zio.aws.iot.model.StreamFile(
      fileId.map(value => value),
      s3Location.map(value => value.asEditable)
    )
    def fileId: Option[FileId]
    def s3Location: Option[zio.aws.iot.model.S3Location.ReadOnly]
    def getFileId: ZIO[Any, AwsError, FileId] =
      AwsError.unwrapOptionField("fileId", fileId)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.iot.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StreamFile
  ) extends zio.aws.iot.model.StreamFile.ReadOnly {
    override val fileId: Option[FileId] = scala
      .Option(impl.fileId())
      .map(value => zio.aws.iot.model.primitives.FileId(value))
    override val s3Location: Option[zio.aws.iot.model.S3Location.ReadOnly] =
      scala
        .Option(impl.s3Location())
        .map(value => zio.aws.iot.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StreamFile
  ): zio.aws.iot.model.StreamFile.ReadOnly = new Wrapper(impl)
}
