package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  TotalChecksCount,
  FailedChecksCount,
  CompliantChecksCount,
  NonCompliantChecksCount,
  CanceledChecksCount,
  InProgressChecksCount,
  WaitingForDataCollectionChecksCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaskStatistics(
    totalChecks: Option[TotalChecksCount] = None,
    inProgressChecks: Option[InProgressChecksCount] = None,
    waitingForDataCollectionChecks: Option[
      WaitingForDataCollectionChecksCount
    ] = None,
    compliantChecks: Option[CompliantChecksCount] = None,
    nonCompliantChecks: Option[NonCompliantChecksCount] = None,
    failedChecks: Option[FailedChecksCount] = None,
    canceledChecks: Option[CanceledChecksCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TaskStatistics = {
    import TaskStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TaskStatistics
      .builder()
      .optionallyWith(
        totalChecks.map(value => TotalChecksCount.unwrap(value): Integer)
      )(_.totalChecks)
      .optionallyWith(
        inProgressChecks.map(value =>
          InProgressChecksCount.unwrap(value): Integer
        )
      )(_.inProgressChecks)
      .optionallyWith(
        waitingForDataCollectionChecks.map(value =>
          WaitingForDataCollectionChecksCount.unwrap(value): Integer
        )
      )(_.waitingForDataCollectionChecks)
      .optionallyWith(
        compliantChecks.map(value =>
          CompliantChecksCount.unwrap(value): Integer
        )
      )(_.compliantChecks)
      .optionallyWith(
        nonCompliantChecks.map(value =>
          NonCompliantChecksCount.unwrap(value): Integer
        )
      )(_.nonCompliantChecks)
      .optionallyWith(
        failedChecks.map(value => FailedChecksCount.unwrap(value): Integer)
      )(_.failedChecks)
      .optionallyWith(
        canceledChecks.map(value => CanceledChecksCount.unwrap(value): Integer)
      )(_.canceledChecks)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TaskStatistics.ReadOnly =
    zio.aws.iot.model.TaskStatistics.wrap(buildAwsValue())
}
object TaskStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TaskStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TaskStatistics =
      zio.aws.iot.model.TaskStatistics(
        totalChecks.map(value => value),
        inProgressChecks.map(value => value),
        waitingForDataCollectionChecks.map(value => value),
        compliantChecks.map(value => value),
        nonCompliantChecks.map(value => value),
        failedChecks.map(value => value),
        canceledChecks.map(value => value)
      )
    def totalChecks: Option[TotalChecksCount]
    def inProgressChecks: Option[InProgressChecksCount]
    def waitingForDataCollectionChecks
        : Option[WaitingForDataCollectionChecksCount]
    def compliantChecks: Option[CompliantChecksCount]
    def nonCompliantChecks: Option[NonCompliantChecksCount]
    def failedChecks: Option[FailedChecksCount]
    def canceledChecks: Option[CanceledChecksCount]
    def getTotalChecks: ZIO[Any, AwsError, TotalChecksCount] =
      AwsError.unwrapOptionField("totalChecks", totalChecks)
    def getInProgressChecks: ZIO[Any, AwsError, InProgressChecksCount] =
      AwsError.unwrapOptionField("inProgressChecks", inProgressChecks)
    def getWaitingForDataCollectionChecks
        : ZIO[Any, AwsError, WaitingForDataCollectionChecksCount] =
      AwsError.unwrapOptionField(
        "waitingForDataCollectionChecks",
        waitingForDataCollectionChecks
      )
    def getCompliantChecks: ZIO[Any, AwsError, CompliantChecksCount] =
      AwsError.unwrapOptionField("compliantChecks", compliantChecks)
    def getNonCompliantChecks: ZIO[Any, AwsError, NonCompliantChecksCount] =
      AwsError.unwrapOptionField("nonCompliantChecks", nonCompliantChecks)
    def getFailedChecks: ZIO[Any, AwsError, FailedChecksCount] =
      AwsError.unwrapOptionField("failedChecks", failedChecks)
    def getCanceledChecks: ZIO[Any, AwsError, CanceledChecksCount] =
      AwsError.unwrapOptionField("canceledChecks", canceledChecks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TaskStatistics
  ) extends zio.aws.iot.model.TaskStatistics.ReadOnly {
    override val totalChecks: Option[TotalChecksCount] = scala
      .Option(impl.totalChecks())
      .map(value => zio.aws.iot.model.primitives.TotalChecksCount(value))
    override val inProgressChecks: Option[InProgressChecksCount] = scala
      .Option(impl.inProgressChecks())
      .map(value => zio.aws.iot.model.primitives.InProgressChecksCount(value))
    override val waitingForDataCollectionChecks
        : Option[WaitingForDataCollectionChecksCount] = scala
      .Option(impl.waitingForDataCollectionChecks())
      .map(value =>
        zio.aws.iot.model.primitives.WaitingForDataCollectionChecksCount(value)
      )
    override val compliantChecks: Option[CompliantChecksCount] = scala
      .Option(impl.compliantChecks())
      .map(value => zio.aws.iot.model.primitives.CompliantChecksCount(value))
    override val nonCompliantChecks: Option[NonCompliantChecksCount] = scala
      .Option(impl.nonCompliantChecks())
      .map(value => zio.aws.iot.model.primitives.NonCompliantChecksCount(value))
    override val failedChecks: Option[FailedChecksCount] = scala
      .Option(impl.failedChecks())
      .map(value => zio.aws.iot.model.primitives.FailedChecksCount(value))
    override val canceledChecks: Option[CanceledChecksCount] = scala
      .Option(impl.canceledChecks())
      .map(value => zio.aws.iot.model.primitives.CanceledChecksCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TaskStatistics
  ): zio.aws.iot.model.TaskStatistics.ReadOnly = new Wrapper(impl)
}
