package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.MaxBuckets
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TermsAggregation(maxBuckets: Option[MaxBuckets] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TermsAggregation = {
    import TermsAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TermsAggregation
      .builder()
      .optionallyWith(
        maxBuckets.map(value => MaxBuckets.unwrap(value): Integer)
      )(_.maxBuckets)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TermsAggregation.ReadOnly =
    zio.aws.iot.model.TermsAggregation.wrap(buildAwsValue())
}
object TermsAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TermsAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TermsAggregation =
      zio.aws.iot.model.TermsAggregation(maxBuckets.map(value => value))
    def maxBuckets: Option[MaxBuckets]
    def getMaxBuckets: ZIO[Any, AwsError, MaxBuckets] =
      AwsError.unwrapOptionField("maxBuckets", maxBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TermsAggregation
  ) extends zio.aws.iot.model.TermsAggregation.ReadOnly {
    override val maxBuckets: Option[MaxBuckets] = scala
      .Option(impl.maxBuckets())
      .map(value => zio.aws.iot.model.primitives.MaxBuckets(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TermsAggregation
  ): zio.aws.iot.model.TermsAggregation.ReadOnly = new Wrapper(impl)
}
