package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PolicyName,
  ClientId,
  CognitoIdentityPoolId,
  Principal
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TestAuthorizationRequest(
    principal: Option[Principal] = None,
    cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = None,
    authInfos: Iterable[zio.aws.iot.model.AuthInfo],
    clientId: Option[ClientId] = None,
    policyNamesToAdd: Option[Iterable[PolicyName]] = None,
    policyNamesToSkip: Option[Iterable[PolicyName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestAuthorizationRequest = {
    import TestAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
      .builder()
      .optionallyWith(
        principal.map(value => Principal.unwrap(value): java.lang.String)
      )(_.principal)
      .optionallyWith(
        cognitoIdentityPoolId.map(value =>
          CognitoIdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.cognitoIdentityPoolId)
      .authInfos(authInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        policyNamesToAdd.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNamesToAdd)
      .optionallyWith(
        policyNamesToSkip.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNamesToSkip)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestAuthorizationRequest.ReadOnly =
    zio.aws.iot.model.TestAuthorizationRequest.wrap(buildAwsValue())
}
object TestAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestAuthorizationRequest =
      zio.aws.iot.model.TestAuthorizationRequest(
        principal.map(value => value),
        cognitoIdentityPoolId.map(value => value),
        authInfos.map { item =>
          item.asEditable
        },
        clientId.map(value => value),
        policyNamesToAdd.map(value => value),
        policyNamesToSkip.map(value => value)
      )
    def principal: Option[Principal]
    def cognitoIdentityPoolId: Option[CognitoIdentityPoolId]
    def authInfos: List[zio.aws.iot.model.AuthInfo.ReadOnly]
    def clientId: Option[ClientId]
    def policyNamesToAdd: Option[List[PolicyName]]
    def policyNamesToSkip: Option[List[PolicyName]]
    def getPrincipal: ZIO[Any, AwsError, Principal] =
      AwsError.unwrapOptionField("principal", principal)
    def getCognitoIdentityPoolId: ZIO[Any, AwsError, CognitoIdentityPoolId] =
      AwsError.unwrapOptionField("cognitoIdentityPoolId", cognitoIdentityPoolId)
    def getAuthInfos
        : ZIO[Any, Nothing, List[zio.aws.iot.model.AuthInfo.ReadOnly]] =
      ZIO.succeed(authInfos)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getPolicyNamesToAdd: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNamesToAdd", policyNamesToAdd)
    def getPolicyNamesToSkip: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNamesToSkip", policyNamesToSkip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ) extends zio.aws.iot.model.TestAuthorizationRequest.ReadOnly {
    override val principal: Option[Principal] = scala
      .Option(impl.principal())
      .map(value => zio.aws.iot.model.primitives.Principal(value))
    override val cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = scala
      .Option(impl.cognitoIdentityPoolId())
      .map(value => zio.aws.iot.model.primitives.CognitoIdentityPoolId(value))
    override val authInfos: List[zio.aws.iot.model.AuthInfo.ReadOnly] = impl
      .authInfos()
      .asScala
      .map { item =>
        zio.aws.iot.model.AuthInfo.wrap(item)
      }
      .toList
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.iot.model.primitives.ClientId(value))
    override val policyNamesToAdd: Option[List[PolicyName]] = scala
      .Option(impl.policyNamesToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.PolicyName(item)
        }.toList
      )
    override val policyNamesToSkip: Option[List[PolicyName]] = scala
      .Option(impl.policyNamesToSkip())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.PolicyName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ): zio.aws.iot.model.TestAuthorizationRequest.ReadOnly = new Wrapper(impl)
}
