package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DisconnectReason, ConnectivityTimestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThingConnectivity(
    connected: Option[Boolean] = None,
    timestamp: Option[ConnectivityTimestamp] = None,
    disconnectReason: Option[DisconnectReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingConnectivity = {
    import ThingConnectivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingConnectivity
      .builder()
      .optionallyWith(connected.map(value => value: java.lang.Boolean))(
        _.connected
      )
      .optionallyWith(
        timestamp.map(value =>
          ConnectivityTimestamp.unwrap(value): java.lang.Long
        )
      )(_.timestamp)
      .optionallyWith(
        disconnectReason.map(value =>
          DisconnectReason.unwrap(value): java.lang.String
        )
      )(_.disconnectReason)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingConnectivity.ReadOnly =
    zio.aws.iot.model.ThingConnectivity.wrap(buildAwsValue())
}
object ThingConnectivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingConnectivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingConnectivity =
      zio.aws.iot.model.ThingConnectivity(
        connected.map(value => value),
        timestamp.map(value => value),
        disconnectReason.map(value => value)
      )
    def connected: Option[Boolean]
    def timestamp: Option[ConnectivityTimestamp]
    def disconnectReason: Option[DisconnectReason]
    def getConnected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("connected", connected)
    def getTimestamp: ZIO[Any, AwsError, ConnectivityTimestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getDisconnectReason: ZIO[Any, AwsError, DisconnectReason] =
      AwsError.unwrapOptionField("disconnectReason", disconnectReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingConnectivity
  ) extends zio.aws.iot.model.ThingConnectivity.ReadOnly {
    override val connected: Option[Boolean] =
      scala.Option(impl.connected()).map(value => value: Boolean)
    override val timestamp: Option[ConnectivityTimestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.iot.model.primitives.ConnectivityTimestamp(value))
    override val disconnectReason: Option[DisconnectReason] = scala
      .Option(impl.disconnectReason())
      .map(value => zio.aws.iot.model.primitives.DisconnectReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingConnectivity
  ): zio.aws.iot.model.ThingConnectivity.ReadOnly = new Wrapper(impl)
}
