package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  AttributeName,
  ThingGroupDescription,
  AttributeValue,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThingGroupDocument(
    thingGroupName: Option[ThingGroupName] = None,
    thingGroupId: Option[ThingGroupId] = None,
    thingGroupDescription: Option[ThingGroupDescription] = None,
    attributes: Option[Map[AttributeName, AttributeValue]] = None,
    parentGroupNames: Option[Iterable[ThingGroupName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingGroupDocument = {
    import ThingGroupDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingGroupDocument
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        thingGroupDescription.map(value =>
          ThingGroupDescription.unwrap(value): java.lang.String
        )
      )(_.thingGroupDescription)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        parentGroupNames.map(value =>
          value.map { item =>
            ThingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parentGroupNames)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingGroupDocument.ReadOnly =
    zio.aws.iot.model.ThingGroupDocument.wrap(buildAwsValue())
}
object ThingGroupDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingGroupDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingGroupDocument =
      zio.aws.iot.model.ThingGroupDocument(
        thingGroupName.map(value => value),
        thingGroupId.map(value => value),
        thingGroupDescription.map(value => value),
        attributes.map(value => value),
        parentGroupNames.map(value => value)
      )
    def thingGroupName: Option[ThingGroupName]
    def thingGroupId: Option[ThingGroupId]
    def thingGroupDescription: Option[ThingGroupDescription]
    def attributes: Option[Map[AttributeName, AttributeValue]]
    def parentGroupNames: Option[List[ThingGroupName]]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getThingGroupDescription: ZIO[Any, AwsError, ThingGroupDescription] =
      AwsError.unwrapOptionField("thingGroupDescription", thingGroupDescription)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getParentGroupNames: ZIO[Any, AwsError, List[ThingGroupName]] =
      AwsError.unwrapOptionField("parentGroupNames", parentGroupNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupDocument
  ) extends zio.aws.iot.model.ThingGroupDocument.ReadOnly {
    override val thingGroupName: Option[ThingGroupName] = scala
      .Option(impl.thingGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupId: Option[ThingGroupId] = scala
      .Option(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val thingGroupDescription: Option[ThingGroupDescription] = scala
      .Option(impl.thingGroupDescription())
      .map(value => zio.aws.iot.model.primitives.ThingGroupDescription(value))
    override val attributes: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AttributeName(
              key
            ) -> zio.aws.iot.model.primitives.AttributeValue(value)
          })
          .toMap
      )
    override val parentGroupNames: Option[List[ThingGroupName]] = scala
      .Option(impl.parentGroupNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ThingGroupName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupDocument
  ): zio.aws.iot.model.ThingGroupDocument.ReadOnly = new Wrapper(impl)
}
