package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CreationDate, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ThingGroupMetadata(
    parentGroupName: Option[ThingGroupName] = None,
    rootToParentThingGroups: Option[
      Iterable[zio.aws.iot.model.GroupNameAndArn]
    ] = None,
    creationDate: Option[CreationDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingGroupMetadata = {
    import ThingGroupMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingGroupMetadata
      .builder()
      .optionallyWith(
        parentGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.parentGroupName)
      .optionallyWith(
        rootToParentThingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rootToParentThingGroups)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingGroupMetadata.ReadOnly =
    zio.aws.iot.model.ThingGroupMetadata.wrap(buildAwsValue())
}
object ThingGroupMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingGroupMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingGroupMetadata =
      zio.aws.iot.model.ThingGroupMetadata(
        parentGroupName.map(value => value),
        rootToParentThingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate.map(value => value)
      )
    def parentGroupName: Option[ThingGroupName]
    def rootToParentThingGroups
        : Option[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]]
    def creationDate: Option[CreationDate]
    def getParentGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("parentGroupName", parentGroupName)
    def getRootToParentThingGroups
        : ZIO[Any, AwsError, List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] =
      AwsError.unwrapOptionField(
        "rootToParentThingGroups",
        rootToParentThingGroups
      )
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupMetadata
  ) extends zio.aws.iot.model.ThingGroupMetadata.ReadOnly {
    override val parentGroupName: Option[ThingGroupName] = scala
      .Option(impl.parentGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val rootToParentThingGroups
        : Option[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] = scala
      .Option(impl.rootToParentThingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.GroupNameAndArn.wrap(item)
        }.toList
      )
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupMetadata
  ): zio.aws.iot.model.ThingGroupMetadata.ReadOnly = new Wrapper(impl)
}
