package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingGroupDescription
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThingGroupProperties(
    thingGroupDescription: Option[ThingGroupDescription] = None,
    attributePayload: Option[zio.aws.iot.model.AttributePayload] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingGroupProperties = {
    import ThingGroupProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingGroupProperties
      .builder()
      .optionallyWith(
        thingGroupDescription.map(value =>
          ThingGroupDescription.unwrap(value): java.lang.String
        )
      )(_.thingGroupDescription)
      .optionallyWith(attributePayload.map(value => value.buildAwsValue()))(
        _.attributePayload
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingGroupProperties.ReadOnly =
    zio.aws.iot.model.ThingGroupProperties.wrap(buildAwsValue())
}
object ThingGroupProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingGroupProperties =
      zio.aws.iot.model.ThingGroupProperties(
        thingGroupDescription.map(value => value),
        attributePayload.map(value => value.asEditable)
      )
    def thingGroupDescription: Option[ThingGroupDescription]
    def attributePayload: Option[zio.aws.iot.model.AttributePayload.ReadOnly]
    def getThingGroupDescription: ZIO[Any, AwsError, ThingGroupDescription] =
      AwsError.unwrapOptionField("thingGroupDescription", thingGroupDescription)
    def getAttributePayload
        : ZIO[Any, AwsError, zio.aws.iot.model.AttributePayload.ReadOnly] =
      AwsError.unwrapOptionField("attributePayload", attributePayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ) extends zio.aws.iot.model.ThingGroupProperties.ReadOnly {
    override val thingGroupDescription: Option[ThingGroupDescription] = scala
      .Option(impl.thingGroupDescription())
      .map(value => zio.aws.iot.model.primitives.ThingGroupDescription(value))
    override val attributePayload
        : Option[zio.aws.iot.model.AttributePayload.ReadOnly] = scala
      .Option(impl.attributePayload())
      .map(value => zio.aws.iot.model.AttributePayload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ): zio.aws.iot.model.ThingGroupProperties.ReadOnly = new Wrapper(impl)
}
