package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThingIndexingConfiguration(
    thingIndexingMode: zio.aws.iot.model.ThingIndexingMode,
    thingConnectivityIndexingMode: Option[
      zio.aws.iot.model.ThingConnectivityIndexingMode
    ] = None,
    deviceDefenderIndexingMode: Option[
      zio.aws.iot.model.DeviceDefenderIndexingMode
    ] = None,
    namedShadowIndexingMode: Option[zio.aws.iot.model.NamedShadowIndexingMode] =
      None,
    managedFields: Option[Iterable[zio.aws.iot.model.Field]] = None,
    customFields: Option[Iterable[zio.aws.iot.model.Field]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration = {
    import ThingIndexingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
      .builder()
      .thingIndexingMode(thingIndexingMode.unwrap)
      .optionallyWith(thingConnectivityIndexingMode.map(value => value.unwrap))(
        _.thingConnectivityIndexingMode
      )
      .optionallyWith(deviceDefenderIndexingMode.map(value => value.unwrap))(
        _.deviceDefenderIndexingMode
      )
      .optionallyWith(namedShadowIndexingMode.map(value => value.unwrap))(
        _.namedShadowIndexingMode
      )
      .optionallyWith(
        managedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedFields)
      .optionallyWith(
        customFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customFields)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly =
    zio.aws.iot.model.ThingIndexingConfiguration.wrap(buildAwsValue())
}
object ThingIndexingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingIndexingConfiguration =
      zio.aws.iot.model.ThingIndexingConfiguration(
        thingIndexingMode,
        thingConnectivityIndexingMode.map(value => value),
        deviceDefenderIndexingMode.map(value => value),
        namedShadowIndexingMode.map(value => value),
        managedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def thingIndexingMode: zio.aws.iot.model.ThingIndexingMode
    def thingConnectivityIndexingMode
        : Option[zio.aws.iot.model.ThingConnectivityIndexingMode]
    def deviceDefenderIndexingMode
        : Option[zio.aws.iot.model.DeviceDefenderIndexingMode]
    def namedShadowIndexingMode
        : Option[zio.aws.iot.model.NamedShadowIndexingMode]
    def managedFields: Option[List[zio.aws.iot.model.Field.ReadOnly]]
    def customFields: Option[List[zio.aws.iot.model.Field.ReadOnly]]
    def getThingIndexingMode
        : ZIO[Any, Nothing, zio.aws.iot.model.ThingIndexingMode] =
      ZIO.succeed(thingIndexingMode)
    def getThingConnectivityIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingConnectivityIndexingMode] =
      AwsError.unwrapOptionField(
        "thingConnectivityIndexingMode",
        thingConnectivityIndexingMode
      )
    def getDeviceDefenderIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.DeviceDefenderIndexingMode] =
      AwsError.unwrapOptionField(
        "deviceDefenderIndexingMode",
        deviceDefenderIndexingMode
      )
    def getNamedShadowIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.NamedShadowIndexingMode] =
      AwsError.unwrapOptionField(
        "namedShadowIndexingMode",
        namedShadowIndexingMode
      )
    def getManagedFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("managedFields", managedFields)
    def getCustomFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("customFields", customFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ) extends zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly {
    override val thingIndexingMode: zio.aws.iot.model.ThingIndexingMode =
      zio.aws.iot.model.ThingIndexingMode.wrap(impl.thingIndexingMode())
    override val thingConnectivityIndexingMode
        : Option[zio.aws.iot.model.ThingConnectivityIndexingMode] = scala
      .Option(impl.thingConnectivityIndexingMode())
      .map(value => zio.aws.iot.model.ThingConnectivityIndexingMode.wrap(value))
    override val deviceDefenderIndexingMode
        : Option[zio.aws.iot.model.DeviceDefenderIndexingMode] = scala
      .Option(impl.deviceDefenderIndexingMode())
      .map(value => zio.aws.iot.model.DeviceDefenderIndexingMode.wrap(value))
    override val namedShadowIndexingMode
        : Option[zio.aws.iot.model.NamedShadowIndexingMode] = scala
      .Option(impl.namedShadowIndexingMode())
      .map(value => zio.aws.iot.model.NamedShadowIndexingMode.wrap(value))
    override val managedFields: Option[List[zio.aws.iot.model.Field.ReadOnly]] =
      scala
        .Option(impl.managedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
    override val customFields: Option[List[zio.aws.iot.model.Field.ReadOnly]] =
      scala
        .Option(impl.customFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ): zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly = new Wrapper(impl)
}
