package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AttributeName, ThingTypeDescription}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThingTypeProperties(
    thingTypeDescription: Option[ThingTypeDescription] = None,
    searchableAttributes: Option[Iterable[AttributeName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingTypeProperties = {
    import ThingTypeProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingTypeProperties
      .builder()
      .optionallyWith(
        thingTypeDescription.map(value =>
          ThingTypeDescription.unwrap(value): java.lang.String
        )
      )(_.thingTypeDescription)
      .optionallyWith(
        searchableAttributes.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.searchableAttributes)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingTypeProperties.ReadOnly =
    zio.aws.iot.model.ThingTypeProperties.wrap(buildAwsValue())
}
object ThingTypeProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingTypeProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingTypeProperties =
      zio.aws.iot.model.ThingTypeProperties(
        thingTypeDescription.map(value => value),
        searchableAttributes.map(value => value)
      )
    def thingTypeDescription: Option[ThingTypeDescription]
    def searchableAttributes: Option[List[AttributeName]]
    def getThingTypeDescription: ZIO[Any, AwsError, ThingTypeDescription] =
      AwsError.unwrapOptionField("thingTypeDescription", thingTypeDescription)
    def getSearchableAttributes: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("searchableAttributes", searchableAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeProperties
  ) extends zio.aws.iot.model.ThingTypeProperties.ReadOnly {
    override val thingTypeDescription: Option[ThingTypeDescription] = scala
      .Option(impl.thingTypeDescription())
      .map(value => zio.aws.iot.model.primitives.ThingTypeDescription(value))
    override val searchableAttributes: Option[List[AttributeName]] = scala
      .Option(impl.searchableAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.AttributeName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeProperties
  ): zio.aws.iot.model.ThingTypeProperties.ReadOnly = new Wrapper(impl)
}
