package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{LastUpdatedAtDate, CreatedAtDate, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TopicRuleDestination(
    arn: Option[AwsArn] = None,
    status: Option[zio.aws.iot.model.TopicRuleDestinationStatus] = None,
    createdAt: Option[CreatedAtDate] = None,
    lastUpdatedAt: Option[LastUpdatedAtDate] = None,
    statusReason: Option[String] = None,
    httpUrlProperties: Option[zio.aws.iot.model.HttpUrlDestinationProperties] =
      None,
    vpcProperties: Option[zio.aws.iot.model.VpcDestinationProperties] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRuleDestination = {
    import TopicRuleDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRuleDestination
      .builder()
      .optionallyWith(arn.map(value => AwsArn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAt.map(value => CreatedAtDate.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAtDate.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(httpUrlProperties.map(value => value.buildAwsValue()))(
        _.httpUrlProperties
      )
      .optionallyWith(vpcProperties.map(value => value.buildAwsValue()))(
        _.vpcProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRuleDestination.ReadOnly =
    zio.aws.iot.model.TopicRuleDestination.wrap(buildAwsValue())
}
object TopicRuleDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRuleDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRuleDestination =
      zio.aws.iot.model.TopicRuleDestination(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        statusReason.map(value => value),
        httpUrlProperties.map(value => value.asEditable),
        vpcProperties.map(value => value.asEditable)
      )
    def arn: Option[AwsArn]
    def status: Option[zio.aws.iot.model.TopicRuleDestinationStatus]
    def createdAt: Option[CreatedAtDate]
    def lastUpdatedAt: Option[LastUpdatedAtDate]
    def statusReason: Option[String]
    def httpUrlProperties
        : Option[zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly]
    def vpcProperties
        : Option[zio.aws.iot.model.VpcDestinationProperties.ReadOnly]
    def getArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.TopicRuleDestinationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAtDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAtDate] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getHttpUrlProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("httpUrlProperties", httpUrlProperties)
    def getVpcProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.VpcDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("vpcProperties", vpcProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestination
  ) extends zio.aws.iot.model.TopicRuleDestination.ReadOnly {
    override val arn: Option[AwsArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val status: Option[zio.aws.iot.model.TopicRuleDestinationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iot.model.TopicRuleDestinationStatus.wrap(value))
    override val createdAt: Option[CreatedAtDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.CreatedAtDate(value))
    override val lastUpdatedAt: Option[LastUpdatedAtDate] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.LastUpdatedAtDate(value))
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val httpUrlProperties
        : Option[zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly] =
      scala
        .Option(impl.httpUrlProperties())
        .map(value =>
          zio.aws.iot.model.HttpUrlDestinationProperties.wrap(value)
        )
    override val vpcProperties
        : Option[zio.aws.iot.model.VpcDestinationProperties.ReadOnly] = scala
      .Option(impl.vpcProperties())
      .map(value => zio.aws.iot.model.VpcDestinationProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestination
  ): zio.aws.iot.model.TopicRuleDestination.ReadOnly = new Wrapper(impl)
}
