package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RuleArn,
  RuleName,
  CreatedAtDate,
  IsDisabled,
  TopicPattern
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TopicRuleListItem(
    ruleArn: Option[RuleArn] = None,
    ruleName: Option[RuleName] = None,
    topicPattern: Option[TopicPattern] = None,
    createdAt: Option[CreatedAtDate] = None,
    ruleDisabled: Option[IsDisabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRuleListItem = {
    import TopicRuleListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRuleListItem
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        topicPattern.map(value => TopicPattern.unwrap(value): java.lang.String)
      )(_.topicPattern)
      .optionallyWith(
        createdAt.map(value => CreatedAtDate.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRuleListItem.ReadOnly =
    zio.aws.iot.model.TopicRuleListItem.wrap(buildAwsValue())
}
object TopicRuleListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRuleListItem =
      zio.aws.iot.model.TopicRuleListItem(
        ruleArn.map(value => value),
        ruleName.map(value => value),
        topicPattern.map(value => value),
        createdAt.map(value => value),
        ruleDisabled.map(value => value)
      )
    def ruleArn: Option[RuleArn]
    def ruleName: Option[RuleName]
    def topicPattern: Option[TopicPattern]
    def createdAt: Option[CreatedAtDate]
    def ruleDisabled: Option[IsDisabled]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getTopicPattern: ZIO[Any, AwsError, TopicPattern] =
      AwsError.unwrapOptionField("topicPattern", topicPattern)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAtDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ) extends zio.aws.iot.model.TopicRuleListItem.ReadOnly {
    override val ruleArn: Option[RuleArn] = scala
      .Option(impl.ruleArn())
      .map(value => zio.aws.iot.model.primitives.RuleArn(value))
    override val ruleName: Option[RuleName] = scala
      .Option(impl.ruleName())
      .map(value => zio.aws.iot.model.primitives.RuleName(value))
    override val topicPattern: Option[TopicPattern] = scala
      .Option(impl.topicPattern())
      .map(value => zio.aws.iot.model.primitives.TopicPattern(value))
    override val createdAt: Option[CreatedAtDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.CreatedAtDate(value))
    override val ruleDisabled: Option[IsDisabled] = scala
      .Option(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ): zio.aws.iot.model.TopicRuleListItem.ReadOnly = new Wrapper(impl)
}
