package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsIotSqlVersion,
  IsDisabled,
  Description,
  SQL
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TopicRulePayload(
    sql: SQL,
    description: Option[Description] = None,
    actions: Iterable[zio.aws.iot.model.Action],
    ruleDisabled: Option[IsDisabled] = None,
    awsIotSqlVersion: Option[AwsIotSqlVersion] = None,
    errorAction: Option[zio.aws.iot.model.Action] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRulePayload = {
    import TopicRulePayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRulePayload
      .builder()
      .sql(SQL.unwrap(sql): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .optionallyWith(
        awsIotSqlVersion.map(value =>
          AwsIotSqlVersion.unwrap(value): java.lang.String
        )
      )(_.awsIotSqlVersion)
      .optionallyWith(errorAction.map(value => value.buildAwsValue()))(
        _.errorAction
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRulePayload.ReadOnly =
    zio.aws.iot.model.TopicRulePayload.wrap(buildAwsValue())
}
object TopicRulePayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRulePayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRulePayload =
      zio.aws.iot.model.TopicRulePayload(
        sql,
        description.map(value => value),
        actions.map { item =>
          item.asEditable
        },
        ruleDisabled.map(value => value),
        awsIotSqlVersion.map(value => value),
        errorAction.map(value => value.asEditable)
      )
    def sql: SQL
    def description: Option[Description]
    def actions: List[zio.aws.iot.model.Action.ReadOnly]
    def ruleDisabled: Option[IsDisabled]
    def awsIotSqlVersion: Option[AwsIotSqlVersion]
    def errorAction: Option[zio.aws.iot.model.Action.ReadOnly]
    def getSql: ZIO[Any, Nothing, SQL] = ZIO.succeed(sql)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActions: ZIO[Any, Nothing, List[zio.aws.iot.model.Action.ReadOnly]] =
      ZIO.succeed(actions)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
    def getAwsIotSqlVersion: ZIO[Any, AwsError, AwsIotSqlVersion] =
      AwsError.unwrapOptionField("awsIotSqlVersion", awsIotSqlVersion)
    def getErrorAction: ZIO[Any, AwsError, zio.aws.iot.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("errorAction", errorAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRulePayload
  ) extends zio.aws.iot.model.TopicRulePayload.ReadOnly {
    override val sql: SQL = zio.aws.iot.model.primitives.SQL(impl.sql())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.Description(value))
    override val actions: List[zio.aws.iot.model.Action.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.iot.model.Action.wrap(item)
      }
      .toList
    override val ruleDisabled: Option[IsDisabled] = scala
      .Option(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
    override val awsIotSqlVersion: Option[AwsIotSqlVersion] = scala
      .Option(impl.awsIotSqlVersion())
      .map(value => zio.aws.iot.model.primitives.AwsIotSqlVersion(value))
    override val errorAction: Option[zio.aws.iot.model.Action.ReadOnly] = scala
      .Option(impl.errorAction())
      .map(value => zio.aws.iot.model.Action.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRulePayload
  ): zio.aws.iot.model.TopicRulePayload.ReadOnly = new Wrapper(impl)
}
