package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AuditDescription,
  SuppressIndefinitely,
  Timestamp,
  AuditCheckName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateAuditSuppressionRequest(
    checkName: AuditCheckName,
    resourceIdentifier: zio.aws.iot.model.ResourceIdentifier,
    expirationDate: Option[Timestamp] = None,
    suppressIndefinitely: Option[SuppressIndefinitely] = None,
    description: Option[AuditDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest = {
    import UpdateAuditSuppressionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest
      .builder()
      .checkName(AuditCheckName.unwrap(checkName): java.lang.String)
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        suppressIndefinitely.map(value =>
          SuppressIndefinitely.unwrap(value): java.lang.Boolean
        )
      )(_.suppressIndefinitely)
      .optionallyWith(
        description.map(value =>
          AuditDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateAuditSuppressionRequest.ReadOnly =
    zio.aws.iot.model.UpdateAuditSuppressionRequest.wrap(buildAwsValue())
}
object UpdateAuditSuppressionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateAuditSuppressionRequest =
      zio.aws.iot.model.UpdateAuditSuppressionRequest(
        checkName,
        resourceIdentifier.asEditable,
        expirationDate.map(value => value),
        suppressIndefinitely.map(value => value),
        description.map(value => value)
      )
    def checkName: AuditCheckName
    def resourceIdentifier: zio.aws.iot.model.ResourceIdentifier.ReadOnly
    def expirationDate: Option[Timestamp]
    def suppressIndefinitely: Option[SuppressIndefinitely]
    def description: Option[AuditDescription]
    def getCheckName: ZIO[Any, Nothing, AuditCheckName] = ZIO.succeed(checkName)
    def getResourceIdentifier
        : ZIO[Any, Nothing, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      ZIO.succeed(resourceIdentifier)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getSuppressIndefinitely: ZIO[Any, AwsError, SuppressIndefinitely] =
      AwsError.unwrapOptionField("suppressIndefinitely", suppressIndefinitely)
    def getDescription: ZIO[Any, AwsError, AuditDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest
  ) extends zio.aws.iot.model.UpdateAuditSuppressionRequest.ReadOnly {
    override val checkName: AuditCheckName =
      zio.aws.iot.model.primitives.AuditCheckName(impl.checkName())
    override val resourceIdentifier
        : zio.aws.iot.model.ResourceIdentifier.ReadOnly =
      zio.aws.iot.model.ResourceIdentifier.wrap(impl.resourceIdentifier())
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val suppressIndefinitely: Option[SuppressIndefinitely] = scala
      .Option(impl.suppressIndefinitely())
      .map(value => zio.aws.iot.model.primitives.SuppressIndefinitely(value))
    override val description: Option[AuditDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.AuditDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest
  ): zio.aws.iot.model.UpdateAuditSuppressionRequest.ReadOnly = new Wrapper(
    impl
  )
}
