package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Timestamp,
  CustomMetricDisplayName,
  CustomMetricArn,
  MetricName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateCustomMetricResponse(
    metricName: Option[MetricName] = None,
    metricArn: Option[CustomMetricArn] = None,
    metricType: Option[zio.aws.iot.model.CustomMetricType] = None,
    displayName: Option[CustomMetricDisplayName] = None,
    creationDate: Option[Timestamp] = None,
    lastModifiedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse = {
    import UpdateCustomMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricArn.map(value => CustomMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .optionallyWith(metricType.map(value => value.unwrap))(_.metricType)
      .optionallyWith(
        displayName.map(value =>
          CustomMetricDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly =
    zio.aws.iot.model.UpdateCustomMetricResponse.wrap(buildAwsValue())
}
object UpdateCustomMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateCustomMetricResponse =
      zio.aws.iot.model.UpdateCustomMetricResponse(
        metricName.map(value => value),
        metricArn.map(value => value),
        metricType.map(value => value),
        displayName.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def metricName: Option[MetricName]
    def metricArn: Option[CustomMetricArn]
    def metricType: Option[zio.aws.iot.model.CustomMetricType]
    def displayName: Option[CustomMetricDisplayName]
    def creationDate: Option[Timestamp]
    def lastModifiedDate: Option[Timestamp]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricArn: ZIO[Any, AwsError, CustomMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
    def getMetricType: ZIO[Any, AwsError, zio.aws.iot.model.CustomMetricType] =
      AwsError.unwrapOptionField("metricType", metricType)
    def getDisplayName: ZIO[Any, AwsError, CustomMetricDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse
  ) extends zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly {
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
    override val metricArn: Option[CustomMetricArn] = scala
      .Option(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.CustomMetricArn(value))
    override val metricType: Option[zio.aws.iot.model.CustomMetricType] = scala
      .Option(impl.metricType())
      .map(value => zio.aws.iot.model.CustomMetricType.wrap(value))
    override val displayName: Option[CustomMetricDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.iot.model.primitives.CustomMetricDisplayName(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Option[Timestamp] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse
  ): zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly = new Wrapper(impl)
}
