package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Timestamp,
  DimensionStringValue,
  DimensionArn,
  DimensionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateDimensionResponse(
    name: Option[DimensionName] = None,
    arn: Option[DimensionArn] = None,
    `type`: Option[zio.aws.iot.model.DimensionType] = None,
    stringValues: Option[Iterable[DimensionStringValue]] = None,
    creationDate: Option[Timestamp] = None,
    lastModifiedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDimensionResponse = {
    import UpdateDimensionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDimensionResponse
      .builder()
      .optionallyWith(
        name.map(value => DimensionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => DimensionArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        stringValues.map(value =>
          value.map { item =>
            DimensionStringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stringValues)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDimensionResponse.ReadOnly =
    zio.aws.iot.model.UpdateDimensionResponse.wrap(buildAwsValue())
}
object UpdateDimensionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDimensionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDimensionResponse =
      zio.aws.iot.model.UpdateDimensionResponse(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        stringValues.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def name: Option[DimensionName]
    def arn: Option[DimensionArn]
    def `type`: Option[zio.aws.iot.model.DimensionType]
    def stringValues: Option[List[DimensionStringValue]]
    def creationDate: Option[Timestamp]
    def lastModifiedDate: Option[Timestamp]
    def getName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, DimensionArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.iot.model.DimensionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStringValues: ZIO[Any, AwsError, List[DimensionStringValue]] =
      AwsError.unwrapOptionField("stringValues", stringValues)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDimensionResponse
  ) extends zio.aws.iot.model.UpdateDimensionResponse.ReadOnly {
    override val name: Option[DimensionName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val arn: Option[DimensionArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iot.model.primitives.DimensionArn(value))
    override val `type`: Option[zio.aws.iot.model.DimensionType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.iot.model.DimensionType.wrap(value))
    override val stringValues: Option[List[DimensionStringValue]] = scala
      .Option(impl.stringValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.DimensionStringValue(item)
        }.toList
      )
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Option[Timestamp] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDimensionResponse
  ): zio.aws.iot.model.UpdateDimensionResponse.ReadOnly = new Wrapper(impl)
}
