package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DomainConfigurationArn,
  ReservedDomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDomainConfigurationResponse(
    domainConfigurationName: Option[ReservedDomainConfigurationName] = None,
    domainConfigurationArn: Option[DomainConfigurationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse = {
    import UpdateDomainConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse
      .builder()
      .optionallyWith(
        domainConfigurationName.map(value =>
          ReservedDomainConfigurationName.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationName)
      .optionallyWith(
        domainConfigurationArn.map(value =>
          DomainConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly =
    zio.aws.iot.model.UpdateDomainConfigurationResponse.wrap(buildAwsValue())
}
object UpdateDomainConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDomainConfigurationResponse =
      zio.aws.iot.model.UpdateDomainConfigurationResponse(
        domainConfigurationName.map(value => value),
        domainConfigurationArn.map(value => value)
      )
    def domainConfigurationName: Option[ReservedDomainConfigurationName]
    def domainConfigurationArn: Option[DomainConfigurationArn]
    def getDomainConfigurationName
        : ZIO[Any, AwsError, ReservedDomainConfigurationName] = AwsError
      .unwrapOptionField("domainConfigurationName", domainConfigurationName)
    def getDomainConfigurationArn: ZIO[Any, AwsError, DomainConfigurationArn] =
      AwsError.unwrapOptionField(
        "domainConfigurationArn",
        domainConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse
  ) extends zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly {
    override val domainConfigurationName
        : Option[ReservedDomainConfigurationName] = scala
      .Option(impl.domainConfigurationName())
      .map(value =>
        zio.aws.iot.model.primitives.ReservedDomainConfigurationName(value)
      )
    override val domainConfigurationArn: Option[DomainConfigurationArn] = scala
      .Option(impl.domainConfigurationArn())
      .map(value => zio.aws.iot.model.primitives.DomainConfigurationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse
  ): zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
