package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateEventConfigurationsRequest(
    eventConfigurations: Option[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest = {
    import UpdateEventConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest
      .builder()
      .optionallyWith(
        eventConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.eventConfigurationsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateEventConfigurationsRequest.ReadOnly =
    zio.aws.iot.model.UpdateEventConfigurationsRequest.wrap(buildAwsValue())
}
object UpdateEventConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateEventConfigurationsRequest =
      zio.aws.iot.model.UpdateEventConfigurationsRequest(
        eventConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def eventConfigurations: Option[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration.ReadOnly]
    ]
    def getEventConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.EventType,
      zio.aws.iot.model.Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField("eventConfigurations", eventConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest
  ) extends zio.aws.iot.model.UpdateEventConfigurationsRequest.ReadOnly {
    override val eventConfigurations: Option[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration.ReadOnly]
    ] = scala
      .Option(impl.eventConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.EventType
              .wrap(key) -> zio.aws.iot.model.Configuration.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest
  ): zio.aws.iot.model.UpdateEventConfigurationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
