package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IndexName,
  AggregationField,
  FleetMetricPeriod,
  OptionalVersion,
  FleetMetricDescription,
  FleetMetricName,
  QueryVersion,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFleetMetricRequest(
    metricName: FleetMetricName,
    queryString: Option[QueryString] = None,
    aggregationType: Option[zio.aws.iot.model.AggregationType] = None,
    period: Option[FleetMetricPeriod] = None,
    aggregationField: Option[AggregationField] = None,
    description: Option[FleetMetricDescription] = None,
    queryVersion: Option[QueryVersion] = None,
    indexName: IndexName,
    unit: Option[zio.aws.iot.model.FleetMetricUnit] = None,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest = {
    import UpdateFleetMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
      .builder()
      .metricName(FleetMetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(aggregationType.map(value => value.buildAwsValue()))(
        _.aggregationType
      )
      .optionallyWith(
        period.map(value => FleetMetricPeriod.unwrap(value): Integer)
      )(_.period)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        description.map(value =>
          FleetMetricDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly =
    zio.aws.iot.model.UpdateFleetMetricRequest.wrap(buildAwsValue())
}
object UpdateFleetMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateFleetMetricRequest =
      zio.aws.iot.model.UpdateFleetMetricRequest(
        metricName,
        queryString.map(value => value),
        aggregationType.map(value => value.asEditable),
        period.map(value => value),
        aggregationField.map(value => value),
        description.map(value => value),
        queryVersion.map(value => value),
        indexName,
        unit.map(value => value),
        expectedVersion.map(value => value)
      )
    def metricName: FleetMetricName
    def queryString: Option[QueryString]
    def aggregationType: Option[zio.aws.iot.model.AggregationType.ReadOnly]
    def period: Option[FleetMetricPeriod]
    def aggregationField: Option[AggregationField]
    def description: Option[FleetMetricDescription]
    def queryVersion: Option[QueryVersion]
    def indexName: IndexName
    def unit: Option[zio.aws.iot.model.FleetMetricUnit]
    def expectedVersion: Option[OptionalVersion]
    def getMetricName: ZIO[Any, Nothing, FleetMetricName] =
      ZIO.succeed(metricName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getAggregationType
        : ZIO[Any, AwsError, zio.aws.iot.model.AggregationType.ReadOnly] =
      AwsError.unwrapOptionField("aggregationType", aggregationType)
    def getPeriod: ZIO[Any, AwsError, FleetMetricPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getDescription: ZIO[Any, AwsError, FleetMetricDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getUnit: ZIO[Any, AwsError, zio.aws.iot.model.FleetMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ) extends zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly {
    override val metricName: FleetMetricName =
      zio.aws.iot.model.primitives.FleetMetricName(impl.metricName())
    override val queryString: Option[QueryString] = scala
      .Option(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val aggregationType
        : Option[zio.aws.iot.model.AggregationType.ReadOnly] = scala
      .Option(impl.aggregationType())
      .map(value => zio.aws.iot.model.AggregationType.wrap(value))
    override val period: Option[FleetMetricPeriod] = scala
      .Option(impl.period())
      .map(value => zio.aws.iot.model.primitives.FleetMetricPeriod(value))
    override val aggregationField: Option[AggregationField] = scala
      .Option(impl.aggregationField())
      .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val description: Option[FleetMetricDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.FleetMetricDescription(value))
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val indexName: IndexName =
      zio.aws.iot.model.primitives.IndexName(impl.indexName())
    override val unit: Option[zio.aws.iot.model.FleetMetricUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.iot.model.FleetMetricUnit.wrap(value))
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ): zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly = new Wrapper(impl)
}
