package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateIndexingConfigurationRequest(
    thingIndexingConfiguration: Option[
      zio.aws.iot.model.ThingIndexingConfiguration
    ] = None,
    thingGroupIndexingConfiguration: Option[
      zio.aws.iot.model.ThingGroupIndexingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest = {
    import UpdateIndexingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest
      .builder()
      .optionallyWith(
        thingIndexingConfiguration.map(value => value.buildAwsValue())
      )(_.thingIndexingConfiguration)
      .optionallyWith(
        thingGroupIndexingConfiguration.map(value => value.buildAwsValue())
      )(_.thingGroupIndexingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.UpdateIndexingConfigurationRequest.ReadOnly =
    zio.aws.iot.model.UpdateIndexingConfigurationRequest.wrap(buildAwsValue())
}
object UpdateIndexingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateIndexingConfigurationRequest =
      zio.aws.iot.model.UpdateIndexingConfigurationRequest(
        thingIndexingConfiguration.map(value => value.asEditable),
        thingGroupIndexingConfiguration.map(value => value.asEditable)
      )
    def thingIndexingConfiguration
        : Option[zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly]
    def thingGroupIndexingConfiguration
        : Option[zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly]
    def getThingIndexingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thingIndexingConfiguration",
      thingIndexingConfiguration
    )
    def getThingGroupIndexingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thingGroupIndexingConfiguration",
      thingGroupIndexingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest
  ) extends zio.aws.iot.model.UpdateIndexingConfigurationRequest.ReadOnly {
    override val thingIndexingConfiguration
        : Option[zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly] = scala
      .Option(impl.thingIndexingConfiguration())
      .map(value => zio.aws.iot.model.ThingIndexingConfiguration.wrap(value))
    override val thingGroupIndexingConfiguration
        : Option[zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly] =
      scala
        .Option(impl.thingGroupIndexingConfiguration())
        .map(value =>
          zio.aws.iot.model.ThingGroupIndexingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest
  ): zio.aws.iot.model.UpdateIndexingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
