package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{MitigationActionId, MitigationActionArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMitigationActionResponse(
    actionArn: Option[MitigationActionArn] = None,
    actionId: Option[MitigationActionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse = {
    import UpdateMitigationActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
      .builder()
      .optionallyWith(
        actionArn.map(value =>
          MitigationActionArn.unwrap(value): java.lang.String
        )
      )(_.actionArn)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly =
    zio.aws.iot.model.UpdateMitigationActionResponse.wrap(buildAwsValue())
}
object UpdateMitigationActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateMitigationActionResponse =
      zio.aws.iot.model.UpdateMitigationActionResponse(
        actionArn.map(value => value),
        actionId.map(value => value)
      )
    def actionArn: Option[MitigationActionArn]
    def actionId: Option[MitigationActionId]
    def getActionArn: ZIO[Any, AwsError, MitigationActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ) extends zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly {
    override val actionArn: Option[MitigationActionArn] = scala
      .Option(impl.actionArn())
      .map(value => zio.aws.iot.model.primitives.MitigationActionArn(value))
    override val actionId: Option[MitigationActionId] = scala
      .Option(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ): zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
