package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ScheduledAuditName,
  AuditCheckName,
  DayOfMonth
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateScheduledAuditRequest(
    frequency: Option[zio.aws.iot.model.AuditFrequency] = None,
    dayOfMonth: Option[DayOfMonth] = None,
    dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = None,
    targetCheckNames: Option[Iterable[AuditCheckName]] = None,
    scheduledAuditName: ScheduledAuditName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest = {
    import UpdateScheduledAuditRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest
      .builder()
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .optionallyWith(
        targetCheckNames.map(value =>
          value.map { item =>
            AuditCheckName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetCheckNames)
      .scheduledAuditName(
        ScheduledAuditName.unwrap(scheduledAuditName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateScheduledAuditRequest.ReadOnly =
    zio.aws.iot.model.UpdateScheduledAuditRequest.wrap(buildAwsValue())
}
object UpdateScheduledAuditRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateScheduledAuditRequest =
      zio.aws.iot.model.UpdateScheduledAuditRequest(
        frequency.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        targetCheckNames.map(value => value),
        scheduledAuditName
      )
    def frequency: Option[zio.aws.iot.model.AuditFrequency]
    def dayOfMonth: Option[DayOfMonth]
    def dayOfWeek: Option[zio.aws.iot.model.DayOfWeek]
    def targetCheckNames: Option[List[AuditCheckName]]
    def scheduledAuditName: ScheduledAuditName
    def getFrequency: ZIO[Any, AwsError, zio.aws.iot.model.AuditFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getTargetCheckNames: ZIO[Any, AwsError, List[AuditCheckName]] =
      AwsError.unwrapOptionField("targetCheckNames", targetCheckNames)
    def getScheduledAuditName: ZIO[Any, Nothing, ScheduledAuditName] =
      ZIO.succeed(scheduledAuditName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest
  ) extends zio.aws.iot.model.UpdateScheduledAuditRequest.ReadOnly {
    override val frequency: Option[zio.aws.iot.model.AuditFrequency] = scala
      .Option(impl.frequency())
      .map(value => zio.aws.iot.model.AuditFrequency.wrap(value))
    override val dayOfMonth: Option[DayOfMonth] = scala
      .Option(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = scala
      .Option(impl.dayOfWeek())
      .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
    override val targetCheckNames: Option[List[AuditCheckName]] = scala
      .Option(impl.targetCheckNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.AuditCheckName(item)
        }.toList
      )
    override val scheduledAuditName: ScheduledAuditName =
      zio.aws.iot.model.primitives.ScheduledAuditName(impl.scheduledAuditName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest
  ): zio.aws.iot.model.UpdateScheduledAuditRequest.ReadOnly = new Wrapper(impl)
}
