package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DeleteAdditionalMetricsToRetain,
  OptionalVersion,
  SecurityProfileDescription,
  DeleteAlertTargets,
  DeleteBehaviors,
  SecurityProfileName,
  BehaviorMetric
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    securityProfileDescription: Option[SecurityProfileDescription] = None,
    behaviors: Option[Iterable[zio.aws.iot.model.Behavior]] = None,
    alertTargets: Option[
      Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
    ] = None,
    additionalMetricsToRetain: Option[Iterable[BehaviorMetric]] = None,
    additionalMetricsToRetainV2: Option[
      Iterable[zio.aws.iot.model.MetricToRetain]
    ] = None,
    deleteBehaviors: Option[DeleteBehaviors] = None,
    deleteAlertTargets: Option[DeleteAlertTargets] = None,
    deleteAdditionalMetricsToRetain: Option[DeleteAdditionalMetricsToRetain] =
      None,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest = {
    import UpdateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        securityProfileDescription.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.securityProfileDescription)
      .optionallyWith(
        behaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.behaviors)
      .optionallyWith(
        alertTargets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.alertTargetsWithStrings)
      .optionallyWith(
        additionalMetricsToRetain.map(value =>
          value.map { item =>
            BehaviorMetric.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetain)
      .optionallyWith(
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetainV2)
      .optionallyWith(
        deleteBehaviors.map(value =>
          DeleteBehaviors.unwrap(value): java.lang.Boolean
        )
      )(_.deleteBehaviors)
      .optionallyWith(
        deleteAlertTargets.map(value =>
          DeleteAlertTargets.unwrap(value): java.lang.Boolean
        )
      )(_.deleteAlertTargets)
      .optionallyWith(
        deleteAdditionalMetricsToRetain.map(value =>
          DeleteAdditionalMetricsToRetain.unwrap(value): java.lang.Boolean
        )
      )(_.deleteAdditionalMetricsToRetain)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.UpdateSecurityProfileRequest.wrap(buildAwsValue())
}
object UpdateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateSecurityProfileRequest =
      zio.aws.iot.model.UpdateSecurityProfileRequest(
        securityProfileName,
        securityProfileDescription.map(value => value),
        behaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alertTargets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        additionalMetricsToRetain.map(value => value),
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteBehaviors.map(value => value),
        deleteAlertTargets.map(value => value),
        deleteAdditionalMetricsToRetain.map(value => value),
        expectedVersion.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def securityProfileDescription: Option[SecurityProfileDescription]
    def behaviors: Option[List[zio.aws.iot.model.Behavior.ReadOnly]]
    def alertTargets: Option[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]]
    def additionalMetricsToRetain: Option[List[BehaviorMetric]]
    def additionalMetricsToRetainV2
        : Option[List[zio.aws.iot.model.MetricToRetain.ReadOnly]]
    def deleteBehaviors: Option[DeleteBehaviors]
    def deleteAlertTargets: Option[DeleteAlertTargets]
    def deleteAdditionalMetricsToRetain: Option[DeleteAdditionalMetricsToRetain]
    def expectedVersion: Option[OptionalVersion]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getSecurityProfileDescription
        : ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField(
        "securityProfileDescription",
        securityProfileDescription
      )
    def getBehaviors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      AwsError.unwrapOptionField("behaviors", behaviors)
    def getAlertTargets: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("alertTargets", alertTargets)
    def getAdditionalMetricsToRetain: ZIO[Any, AwsError, List[BehaviorMetric]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetain",
        additionalMetricsToRetain
      )
    def getAdditionalMetricsToRetainV2
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetainV2",
        additionalMetricsToRetainV2
      )
    def getDeleteBehaviors: ZIO[Any, AwsError, DeleteBehaviors] =
      AwsError.unwrapOptionField("deleteBehaviors", deleteBehaviors)
    def getDeleteAlertTargets: ZIO[Any, AwsError, DeleteAlertTargets] =
      AwsError.unwrapOptionField("deleteAlertTargets", deleteAlertTargets)
    def getDeleteAdditionalMetricsToRetain
        : ZIO[Any, AwsError, DeleteAdditionalMetricsToRetain] =
      AwsError.unwrapOptionField(
        "deleteAdditionalMetricsToRetain",
        deleteAdditionalMetricsToRetain
      )
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ) extends zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val securityProfileDescription
        : Option[SecurityProfileDescription] = scala
      .Option(impl.securityProfileDescription())
      .map(value =>
        zio.aws.iot.model.primitives.SecurityProfileDescription(value)
      )
    override val behaviors: Option[List[zio.aws.iot.model.Behavior.ReadOnly]] =
      scala
        .Option(impl.behaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Behavior.wrap(item)
          }.toList
        )
    override val alertTargets: Option[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = scala
      .Option(impl.alertTargets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AlertTargetType
              .wrap(key) -> zio.aws.iot.model.AlertTarget.wrap(value)
          })
          .toMap
      )
    override val additionalMetricsToRetain: Option[List[BehaviorMetric]] = scala
      .Option(impl.additionalMetricsToRetain())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.BehaviorMetric(item)
        }.toList
      )
    override val additionalMetricsToRetainV2
        : Option[List[zio.aws.iot.model.MetricToRetain.ReadOnly]] = scala
      .Option(impl.additionalMetricsToRetainV2())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.MetricToRetain.wrap(item)
        }.toList
      )
    override val deleteBehaviors: Option[DeleteBehaviors] = scala
      .Option(impl.deleteBehaviors())
      .map(value => zio.aws.iot.model.primitives.DeleteBehaviors(value))
    override val deleteAlertTargets: Option[DeleteAlertTargets] = scala
      .Option(impl.deleteAlertTargets())
      .map(value => zio.aws.iot.model.primitives.DeleteAlertTargets(value))
    override val deleteAdditionalMetricsToRetain
        : Option[DeleteAdditionalMetricsToRetain] = scala
      .Option(impl.deleteAdditionalMetricsToRetain())
      .map(value =>
        zio.aws.iot.model.primitives.DeleteAdditionalMetricsToRetain(value)
      )
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ): zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
