package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  OverrideDynamicGroups,
  ThingGroupName,
  ThingName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateThingGroupsForThingRequest(
    thingName: Option[ThingName] = None,
    thingGroupsToAdd: Option[Iterable[ThingGroupName]] = None,
    thingGroupsToRemove: Option[Iterable[ThingGroupName]] = None,
    overrideDynamicGroups: Option[OverrideDynamicGroups] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest = {
    import UpdateThingGroupsForThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingGroupsToAdd.map(value =>
          value.map { item =>
            ThingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.thingGroupsToAdd)
      .optionallyWith(
        thingGroupsToRemove.map(value =>
          value.map { item =>
            ThingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.thingGroupsToRemove)
      .optionallyWith(
        overrideDynamicGroups.map(value =>
          OverrideDynamicGroups.unwrap(value): java.lang.Boolean
        )
      )(_.overrideDynamicGroups)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateThingGroupsForThingRequest.ReadOnly =
    zio.aws.iot.model.UpdateThingGroupsForThingRequest.wrap(buildAwsValue())
}
object UpdateThingGroupsForThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateThingGroupsForThingRequest =
      zio.aws.iot.model.UpdateThingGroupsForThingRequest(
        thingName.map(value => value),
        thingGroupsToAdd.map(value => value),
        thingGroupsToRemove.map(value => value),
        overrideDynamicGroups.map(value => value)
      )
    def thingName: Option[ThingName]
    def thingGroupsToAdd: Option[List[ThingGroupName]]
    def thingGroupsToRemove: Option[List[ThingGroupName]]
    def overrideDynamicGroups: Option[OverrideDynamicGroups]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingGroupsToAdd: ZIO[Any, AwsError, List[ThingGroupName]] =
      AwsError.unwrapOptionField("thingGroupsToAdd", thingGroupsToAdd)
    def getThingGroupsToRemove: ZIO[Any, AwsError, List[ThingGroupName]] =
      AwsError.unwrapOptionField("thingGroupsToRemove", thingGroupsToRemove)
    def getOverrideDynamicGroups: ZIO[Any, AwsError, OverrideDynamicGroups] =
      AwsError.unwrapOptionField("overrideDynamicGroups", overrideDynamicGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest
  ) extends zio.aws.iot.model.UpdateThingGroupsForThingRequest.ReadOnly {
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingGroupsToAdd: Option[List[ThingGroupName]] = scala
      .Option(impl.thingGroupsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ThingGroupName(item)
        }.toList
      )
    override val thingGroupsToRemove: Option[List[ThingGroupName]] = scala
      .Option(impl.thingGroupsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ThingGroupName(item)
        }.toList
      )
    override val overrideDynamicGroups: Option[OverrideDynamicGroups] = scala
      .Option(impl.overrideDynamicGroups())
      .map(value => zio.aws.iot.model.primitives.OverrideDynamicGroups(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest
  ): zio.aws.iot.model.UpdateThingGroupsForThingRequest.ReadOnly = new Wrapper(
    impl
  )
}
