package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ViolationEventAdditionalInfo(
    confidenceLevel: Option[zio.aws.iot.model.ConfidenceLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo = {
    import ViolationEventAdditionalInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo
      .builder()
      .optionallyWith(confidenceLevel.map(value => value.unwrap))(
        _.confidenceLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly =
    zio.aws.iot.model.ViolationEventAdditionalInfo.wrap(buildAwsValue())
}
object ViolationEventAdditionalInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ViolationEventAdditionalInfo =
      zio.aws.iot.model
        .ViolationEventAdditionalInfo(confidenceLevel.map(value => value))
    def confidenceLevel: Option[zio.aws.iot.model.ConfidenceLevel]
    def getConfidenceLevel
        : ZIO[Any, AwsError, zio.aws.iot.model.ConfidenceLevel] =
      AwsError.unwrapOptionField("confidenceLevel", confidenceLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo
  ) extends zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly {
    override val confidenceLevel: Option[zio.aws.iot.model.ConfidenceLevel] =
      scala
        .Option(impl.confidenceLevel())
        .map(value => zio.aws.iot.model.ConfidenceLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo
  ): zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly = new Wrapper(impl)
}
