package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AggregationTypeValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregationType(
    name: zio.aws.iot.model.AggregationTypeName,
    values: Optional[Iterable[AggregationTypeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AggregationType = {
    import AggregationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AggregationType
      .builder()
      .name(name.unwrap)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            AggregationTypeValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AggregationType.ReadOnly =
    zio.aws.iot.model.AggregationType.wrap(buildAwsValue())
}
object AggregationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AggregationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AggregationType =
      zio.aws.iot.model.AggregationType(name, values.map(value => value))
    def name: zio.aws.iot.model.AggregationTypeName
    def values: Optional[List[AggregationTypeValue]]
    def getName: ZIO[Any, Nothing, zio.aws.iot.model.AggregationTypeName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, AwsError, List[AggregationTypeValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AggregationType
  ) extends zio.aws.iot.model.AggregationType.ReadOnly {
    override val name: zio.aws.iot.model.AggregationTypeName =
      zio.aws.iot.model.AggregationTypeName.wrap(impl.name())
    override val values: Optional[List[AggregationTypeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.AggregationTypeValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AggregationType
  ): zio.aws.iot.model.AggregationType.ReadOnly = new Wrapper(impl)
}
